#!/bin/bash
PRIMARY_URL="http://ftp.gdsy.info:82/version/liudl/microsoft-jdk-17.0.15-linux-x64.tar.gz"
FALLBACK_URL="https://download.visualstudio.microsoft.com/download/pr/2402ca63-36ec-4864-9de9-f71cde78c7e1/3cb78b12c922d24f0eacf3af58fcd214/microsoft-jdk-17.0.15-linux-x64.tar.gz"
export LANG=zh_CN.UTF-8
echo "***************************************************************************************************************"
echo "*********************************************bash 调整*********************************************************"
echo "***************************************************************************************************************"
current_link=$(ls -l /bin/sh | awk '{print $NF}')
if [ "$current_link" = "dash" ]; then
 echo "[INFO] 当前 /bin/sh 链接到 dash"
         sudo rm -f /bin/sh && sudo ln -s /bin/bash /bin/sh
           # 验证修改结果
            new_link=$(ls -l /bin/sh | awk '{print $NF}')
             if [ "$new_link" = "/bin/bash" ]; then
                  echo "[SUCCESS] 已成功修改为 bash"
            echo "$(date '+%Y-%m-%d %H:%M:%S') /bin/sh changed from dash to bash" >> /var/log/shell_change.log
        else
            echo "[ERROR] 修改失败" >&2
            exit 1
        fi
elif [ "$current_link" = "/bin/bash" ] || [ "$current_link" = "bash" ]; then
      echo "[INFO] /bin/sh 已链接到 bash，无需修改"
else
     echo "[WARNING] 检测到非常规链接：$current_link" >&2
    exit 2
fi

echo 复制项目文件至/opt/alidns
chmod +x alidns
chmod +x start.sh
chmod +x stop.sh
chmod +x status.sh
chmod +x uninstall.sh
mv alidns /etc/init.d
mkdir -p /opt/alidns && mv * /opt/alidns
echo "清理 alidns_linux目录"
cd ..
rm -rf alidns_linux
mkdir -p /opt/soft && cd /opt/soft
# 尝试主链接
if wget  --tries=3 --timeout=10 --http-user=zhaoxh --http-passwd=gdsy123456 -N "$PRIMARY_URL"; then
    echo "下载成功: $PRIMARY_URL"
else
    echo "主链接失败，尝试备用链接..."
    # 尝试备用链接
    if wget --tries=3 --timeout=10 "$FALLBACK_URL"; then
        echo "下载成功: $FALLBACK_URL"
    else
        echo "所有链接均失败"
        exit 1
    fi
fi
echo "开始解压jdk"
tar -xzvf microsoft-jdk-17.0.15-linux-x64.tar.gz
rm -rf microsoft-jdk-17.0.15-linux-x64.tar.gz
cd /etc/init.d
echo "注册服务"
chkconfig --add alidns
chkconfig --list
echo "删除安装脚本"
rm -rf /opt/alidns/setup.sh