/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.InjectionRequest;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sonatype.guice.bean.binders.DependencyAnalyzer;
import org.sonatype.guice.bean.binders.ParameterKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ElementAnalyzer
extends DefaultElementVisitor<Void> {
    private static final DependencyAnalyzer<Object> DEPENDENCY_ANALYZER = new DependencyAnalyzer();
    private final Set<Key<?>> localKeys = new HashSet();
    private final Set<Key<?>> importedKeys = new HashSet();
    private final Binder binder;

    ElementAnalyzer(Binder binder) {
        this.binder = binder;
        this.importedKeys.add(ParameterKeys.PROPERTIES);
    }

    public Set<Key<?>> getImportedKeys() {
        this.importedKeys.removeAll(this.localKeys);
        return this.importedKeys;
    }

    @Override
    public <T> Void visit(Binding<T> binding) {
        if (this.localKeys.add(binding.getKey())) {
            binding.applyTo(this.binder);
            this.importedKeys.addAll((Collection)binding.acceptTargetVisitor(DEPENDENCY_ANALYZER));
        }
        return null;
    }

    @Override
    public Void visit(InjectionRequest<?> injectionRequest) {
        injectionRequest.applyTo(this.binder);
        this.importedKeys.addAll(DependencyAnalyzer.analyze(injectionRequest.getType()));
        return null;
    }

    @Override
    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }
}

