/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.forward;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.BufferedIoOutputStream;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.SimpleIoOutputStream;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.exception.SshChannelOpenException;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.forward.ForwardingTunnelEndpointsProvider;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.forward.TcpForwardingFilter;

public class TcpipServerChannel
extends AbstractServerChannel
implements StreamingChannel,
ForwardingTunnelEndpointsProvider {
    private final TcpForwardingFilter.Type type;
    private IoConnector connector;
    private IoSession ioSession;
    private IoOutputStream out;
    private SshdSocketAddress tunnelEntrance;
    private SshdSocketAddress tunnelExit;
    private SshdSocketAddress originatorAddress;
    private SocketAddress localAddress;
    private final AtomicLong inFlightDataSize = new AtomicLong();
    private StreamingChannel.Streaming streaming = StreamingChannel.Streaming.Sync;

    public TcpipServerChannel(TcpForwardingFilter.Type type, CloseableExecutorService executor) {
        super("", Collections.emptyList(), executor);
        this.type = Objects.requireNonNull(type, "No channel type specified");
    }

    public TcpForwardingFilter.Type getTcpipChannelType() {
        return this.type;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(SocketAddress localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    public StreamingChannel.Streaming getStreaming() {
        return this.streaming;
    }

    @Override
    public void setStreaming(StreamingChannel.Streaming streaming) {
        this.streaming = streaming;
    }

    @Override
    public SshdSocketAddress getTunnelEntrance() {
        return this.tunnelEntrance;
    }

    @Override
    public SshdSocketAddress getTunnelExit() {
        return this.tunnelExit;
    }

    public SshdSocketAddress getOriginatorAddress() {
        return this.originatorAddress;
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f;
        FactoryManager manager;
        Session session;
        SshdSocketAddress address;
        boolean debugEnabled;
        block13: {
            String hostToConnect = buffer.getString();
            int portToConnect = buffer.getInt();
            String originatorIpAddress = buffer.getString();
            int originatorPort = buffer.getInt();
            debugEnabled = this.log.isDebugEnabled();
            if (debugEnabled) {
                this.log.debug("doInit({}) Receiving request for direct tcpip: hostToConnect={}, portToConnect={}, originatorIpAddress={}, originatorPort={}", this, hostToConnect, portToConnect, originatorIpAddress, originatorPort);
            }
            TcpForwardingFilter.Type channelType = this.getTcpipChannelType();
            switch (this.type) {
                case Direct: {
                    address = new SshdSocketAddress(hostToConnect, portToConnect);
                    break;
                }
                case Forwarded: {
                    Forwarder forwarder = this.service.getForwarder();
                    address = forwarder.getForwardedPort(portToConnect);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown server channel type: " + channelType);
                }
            }
            this.originatorAddress = new SshdSocketAddress(originatorIpAddress, originatorPort);
            this.tunnelEntrance = new SshdSocketAddress(hostToConnect, portToConnect);
            this.tunnelExit = address;
            session = this.getSession();
            manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
            TcpForwardingFilter filter = manager.getTcpForwardingFilter();
            f = new DefaultOpenFuture(this, this);
            try {
                if (address != null && filter != null && filter.canConnect(channelType, address, session)) break block13;
                if (debugEnabled) {
                    this.log.debug("doInit(" + this + ")[" + this.type + "][haveFilter=" + (filter != null) + "] filtered out " + address);
                }
                try {
                    f.setException(new SshChannelOpenException(this.getId(), 1, "Connection denied"));
                }
                finally {
                    super.close(true);
                }
                return f;
            }
            catch (Error e) {
                this.warn("doInit({})[{}] failed ({}) to consult forwarding filter: {}", session, channelType, e.getClass().getSimpleName(), e.getMessage(), e);
                throw new RuntimeSshException(e);
            }
        }
        if (this.streaming == StreamingChannel.Streaming.Async) {
            int channelId = this.getId();
            this.out = new BufferedIoOutputStream("aysnc-tcpip-channel@" + channelId, channelId, new ChannelAsyncOutputStream(this, 94){

                @Override
                protected CloseFuture doCloseGracefully() {
                    try {
                        TcpipServerChannel.this.sendEof();
                    }
                    catch (IOException e) {
                        session.exceptionCaught(e);
                    }
                    return super.doCloseGracefully();
                }
            }, this);
        } else {
            this.out = new SimpleIoOutputStream(new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true));
        }
        final long thresholdHigh = CoreModuleProperties.TCPIP_SERVER_CHANNEL_BUFFER_SIZE_THRESHOLD_HIGH.getRequired(this);
        final long thresholdLow = CoreModuleProperties.TCPIP_SERVER_CHANNEL_BUFFER_SIZE_THRESHOLD_LOW.get(this).orElse(thresholdHigh / 2L);
        IoHandler handler = new IoHandler(){

            @Override
            public void messageReceived(final IoSession session, Readable message) throws Exception {
                if (TcpipServerChannel.this.isClosing()) {
                    if (debugEnabled) {
                        TcpipServerChannel.this.log.debug("doInit({}) Ignoring write to channel in CLOSING state", (Object)TcpipServerChannel.this);
                    }
                } else {
                    final int length = message.available();
                    ByteArrayBuffer buffer = new ByteArrayBuffer(length, false);
                    buffer.putBuffer(message);
                    long total = TcpipServerChannel.this.inFlightDataSize.addAndGet(length);
                    if (total > thresholdHigh) {
                        session.suspendRead();
                    }
                    IoWriteFuture ioWriteFuture = TcpipServerChannel.this.out.writeBuffer(buffer);
                    ioWriteFuture.addListener(new SshFutureListener<IoWriteFuture>(){

                        @Override
                        public void operationComplete(IoWriteFuture future) {
                            long total = TcpipServerChannel.this.inFlightDataSize.addAndGet(-length);
                            if (total <= thresholdLow) {
                                session.resumeRead();
                            }
                        }
                    });
                }
            }

            @Override
            public void sessionCreated(IoSession session) throws Exception {
            }

            @Override
            public void sessionClosed(IoSession session) throws Exception {
                TcpipServerChannel.this.close(false);
            }

            @Override
            public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
                boolean immediately;
                boolean bl = immediately = !session.isOpen();
                if (debugEnabled) {
                    TcpipServerChannel.this.log.debug("exceptionCaught({}) signal close immediately={} due to {}[{}]", TcpipServerChannel.this, immediately, cause.getClass().getSimpleName(), cause.getMessage());
                }
                TcpipServerChannel.this.close(immediately);
            }
        };
        IoServiceFactory ioServiceFactory = manager.getIoServiceFactory();
        this.connector = ioServiceFactory.createConnector(handler);
        IoConnectFuture future = this.connector.connect(address.toInetSocketAddress(), null, this.getLocalAddress());
        future.addListener(future1 -> this.handleChannelConnectResult(f, (IoConnectFuture)future1));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelConnectResult(OpenFuture f, IoConnectFuture future) {
        try {
            if (future.isConnected()) {
                this.handleChannelOpenSuccess(f, future.getSession());
                return;
            }
            Throwable problem = ExceptionUtils.peelException(future.getException());
            if (problem != null) {
                this.handleChannelOpenFailure(f, problem);
            }
        }
        catch (RuntimeException t) {
            Throwable e = ExceptionUtils.peelException(t);
            this.signalChannelOpenFailure(e);
            try {
                f.setException(e);
            }
            finally {
                this.notifyStateChanged(e.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelOpenSuccess(OpenFuture f, IoSession session) {
        this.ioSession = session;
        String changeEvent = session.toString();
        try {
            this.signalChannelOpenSuccess();
            f.setOpened();
        }
        catch (Throwable t) {
            Throwable e = ExceptionUtils.peelException(t);
            changeEvent = e.getClass().getSimpleName();
            this.signalChannelOpenFailure(e);
            f.setException(e);
        }
        finally {
            this.notifyStateChanged(changeEvent);
        }
    }

    protected void handleChannelOpenFailure(OpenFuture f, Throwable problem) {
        this.signalChannelOpenFailure(problem);
        this.notifyStateChanged(problem.getClass().getSimpleName());
        try {
            if (problem instanceof ConnectException) {
                f.setException(new SshChannelOpenException(this.getId(), 2, problem.getMessage(), problem));
            } else {
                f.setException(problem);
            }
        }
        finally {
            this.close(true);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(this.out).close(super.getInnerCloseable()).close(new AbstractCloseable(){
            private final CloseableExecutorService executor;
            {
                this.executor = ThreadUtils.newCachedThreadPool("TcpIpServerChannel-ConnectorCleanup[" + TcpipServerChannel.this.getSession() + "]");
            }

            @Override
            protected CloseFuture doCloseGracefully() {
                this.executor.submit(() -> TcpipServerChannel.this.connector.close(false));
                return null;
            }

            @Override
            protected void doCloseImmediately() {
                this.executor.submit(() -> TcpipServerChannel.this.connector.close(true).addListener(f -> this.executor.close(true)));
                super.doCloseImmediately();
            }
        }).build();
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        ByteArrayBuffer buf = ByteArrayBuffer.getCompactClone(data, off, (int)len);
        this.ioSession.writeBuffer(buf).addListener(future -> {
            if (future.isWritten()) {
                this.handleWriteDataSuccess((byte)94, buf.array(), 0, (int)len);
            } else {
                this.handleWriteDataFailure((byte)94, buf.array(), 0, (int)len, future.getException());
            }
        });
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        throw new UnsupportedOperationException(this.getTcpipChannelType() + "Tcpip channel does not support extended data");
    }

    protected void handleWriteDataSuccess(byte cmd, byte[] data, int off, int len) {
        Session session = this.getSession();
        try {
            Window wLocal = this.getLocalWindow();
            wLocal.consumeAndCheck(len);
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataSuccess({})[{}] failed ({}) to consume len={}: {}", this, SshConstants.getCommandMessageName(cmd & 0xFF), e.getClass().getSimpleName(), len, e.getMessage());
            }
            session.exceptionCaught(e);
        }
    }

    protected void handleWriteDataFailure(byte cmd, byte[] data, int off, int len, Throwable t) {
        this.debug("handleWriteDataFailure({})[{}] failed ({}) to write len={}: {}", this, SshConstants.getCommandMessageName(cmd & 0xFF), t.getClass().getSimpleName(), len, t.getMessage(), t);
        if (this.ioSession.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataFailure({})[{}] closing session={}", this, SshConstants.getCommandMessageName(cmd & 0xFF), this.ioSession);
            }
            this.close(false);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Ignoring writeDataFailure {} because ioSession {} is already closing ", (Object)t, (Object)this.ioSession);
        }
    }

    public static abstract class TcpipFactory
    implements ChannelFactory,
    ExecutorServiceCarrier {
        private final TcpForwardingFilter.Type type;

        protected TcpipFactory(TcpForwardingFilter.Type type) {
            this.type = type;
        }

        public final TcpForwardingFilter.Type getType() {
            return this.type;
        }

        @Override
        public final String getName() {
            return this.type.getName();
        }

        @Override
        public CloseableExecutorService getExecutorService() {
            return null;
        }

        @Override
        public Channel createChannel(Session session) throws IOException {
            return new TcpipServerChannel(this.getType(), ThreadUtils.noClose(this.getExecutorService()));
        }
    }
}

