/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.scp.client.CloseableScpClient;

public interface SimpleScpClient
extends Channel {
    default public CloseableScpClient scpLogin(String host, String username, String password) throws IOException {
        return this.scpLogin(host, 22, username, password);
    }

    default public CloseableScpClient scpLogin(String host, int port, String username, String password) throws IOException {
        return this.scpLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty(host, "No host")), port, username, password);
    }

    default public CloseableScpClient scpLogin(String host, String username, KeyPair identity) throws IOException {
        return this.scpLogin(host, 22, username, identity);
    }

    default public CloseableScpClient scpLogin(String host, int port, String username, KeyPair identity) throws IOException {
        return this.scpLogin(InetAddress.getByName(ValidateUtils.checkNotNullAndNotEmpty(host, "No host")), port, username, identity);
    }

    default public CloseableScpClient scpLogin(InetAddress host, String username, String password) throws IOException {
        return this.scpLogin(host, 22, username, password);
    }

    default public CloseableScpClient scpLogin(InetAddress host, int port, String username, String password) throws IOException {
        return this.scpLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host, "No host address"), port), username, password);
    }

    default public CloseableScpClient scpLogin(InetAddress host, String username, KeyPair identity) throws IOException {
        return this.scpLogin(host, 22, username, identity);
    }

    default public CloseableScpClient scpLogin(InetAddress host, int port, String username, KeyPair identity) throws IOException {
        return this.scpLogin((SocketAddress)new InetSocketAddress(Objects.requireNonNull(host, "No host address"), port), username, identity);
    }

    public CloseableScpClient scpLogin(SocketAddress var1, String var2, String var3) throws IOException;

    public CloseableScpClient scpLogin(SocketAddress var1, String var2, KeyPair var3) throws IOException;
}

