/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.ICOSVisitor;

public final class COSInteger
extends COSNumber {
    private static final int LOW = -100;
    private static final int HIGH = 256;
    private static final COSInteger[] STATIC = new COSInteger[357];
    public static final COSInteger ZERO = COSInteger.get(0L);
    public static final COSInteger ONE = COSInteger.get(1L);
    public static final COSInteger TWO = COSInteger.get(2L);
    public static final COSInteger THREE = COSInteger.get(3L);
    private final long value;

    public static COSInteger get(long val2) {
        if (-100L <= val2 && val2 <= 256L) {
            int index = (int)val2 - -100;
            if (STATIC[index] == null) {
                COSInteger.STATIC[index] = new COSInteger(val2);
            }
            return STATIC[index];
        }
        return new COSInteger(val2);
    }

    private COSInteger(long val2) {
        this.value = val2;
    }

    public boolean equals(Object o) {
        return o instanceof COSInteger && ((COSInteger)o).intValue() == this.intValue();
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public String toString() {
        return "COSInt{" + this.value + "}";
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws IOException {
        return visitor.visitFromInt(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(String.valueOf(this.value).getBytes("ISO-8859-1"));
    }
}

