/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.BaseFilter;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.plexus.build.incremental.BuildContext;

@Component(role=MavenFileFilter.class, hint="default")
public class DefaultMavenFileFilter
extends BaseFilter
implements MavenFileFilter {
    @Requirement
    private MavenReaderFilter readerFilter;
    @Requirement
    private BuildContext buildContext;

    @Override
    public void copyFile(File from, File to, boolean filtering, MavenProject mavenProject, List<String> filters, boolean escapedBackslashesInFilePath, String encoding, MavenSession mavenSession) throws MavenFilteringException {
        MavenResourcesExecution mre = new MavenResourcesExecution();
        mre.setMavenProject(mavenProject);
        mre.setFileFilters(filters);
        mre.setEscapeWindowsPaths(escapedBackslashesInFilePath);
        mre.setMavenSession(mavenSession);
        mre.setInjectProjectBuildFilters(true);
        List filterWrappers = this.getDefaultFilterWrappers(mre);
        this.copyFile(from, to, filtering, filterWrappers, encoding);
    }

    @Override
    public void copyFile(MavenFileFilterRequest mavenFileFilterRequest) throws MavenFilteringException {
        List filterWrappers = this.getDefaultFilterWrappers(mavenFileFilterRequest);
        this.copyFile(mavenFileFilterRequest.getFrom(), mavenFileFilterRequest.getTo(), mavenFileFilterRequest.isFiltering(), filterWrappers, mavenFileFilterRequest.getEncoding());
    }

    @Override
    public void copyFile(File from, File to, boolean filtering, List<FileUtils.FilterWrapper> filterWrappers, String encoding) throws MavenFilteringException {
        this.copyFile(from, to, filtering, filterWrappers, encoding, false);
    }

    @Override
    public void copyFile(File from, File to, boolean filtering, List<FileUtils.FilterWrapper> filterWrappers, String encoding, boolean overwrite) throws MavenFilteringException {
        try {
            if (filtering) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("filtering " + from.getPath() + " to " + to.getPath());
                }
                this.filterFile(from, to, encoding, filterWrappers);
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("copy " + from.getPath() + " to " + to.getPath());
                }
                FileUtils.copyFile(from, to, encoding, new FileUtils.FilterWrapper[0], overwrite);
            }
            this.buildContext.refresh(to);
        }
        catch (IOException e) {
            throw new MavenFilteringException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterFile(@Nonnull File from, @Nonnull File to, @Nullable String encoding, @Nullable List<FileUtils.FilterWrapper> wrappers) throws IOException, MavenFilteringException {
        block4: {
            block3: {
                if (wrappers == null || wrappers.size() <= 0) break block3;
                Reader fileReader = null;
                Writer fileWriter = null;
                try {
                    fileReader = this.getFileReader(encoding, from);
                    fileWriter = this.getFileWriter(encoding, to);
                    Reader src = this.readerFilter.filter(fileReader, true, wrappers);
                    IOUtil.copy(src, fileWriter);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileReader);
                    IOUtil.close(fileWriter);
                    throw throwable;
                }
                IOUtil.close(fileReader);
                IOUtil.close(fileWriter);
                break block4;
            }
            if (to.lastModified() < from.lastModified()) {
                FileUtils.copyFile(from, to);
            }
        }
    }

    private Writer getFileWriter(String encoding, File to) throws IOException {
        if (StringUtils.isEmpty(encoding)) {
            return new FileWriter(to);
        }
        FileOutputStream outstream = new FileOutputStream(to);
        return new OutputStreamWriter((OutputStream)outstream, encoding);
    }

    private Reader getFileReader(String encoding, File from) throws FileNotFoundException, UnsupportedEncodingException {
        if (StringUtils.isEmpty(encoding)) {
            return new BufferedReader(new FileReader(from));
        }
        FileInputStream instream = new FileInputStream(from);
        return new BufferedReader(new InputStreamReader((InputStream)instream, encoding));
    }
}

