/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependencies.collect.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependencies.collect.CollectorResult;
import org.apache.maven.shared.dependencies.collect.DependencyCollector;
import org.apache.maven.shared.dependencies.collect.DependencyCollectorException;
import org.apache.maven.shared.dependencies.collect.internal.Invoker;
import org.apache.maven.shared.dependencies.collect.internal.Maven30CollectorResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.util.artifact.DefaultArtifact;

@Component(role=DependencyCollector.class, hint="maven3")
public class Maven30DependencyCollector
implements DependencyCollector {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, org.apache.maven.model.Dependency root) throws DependencyCollectorException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        CollectRequest request = new CollectRequest();
        request.setRoot(Maven30DependencyCollector.toDependency(root, typeRegistry));
        return this.collectDependencies(buildingRequest, request);
    }

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, DependableCoordinate root) throws DependencyCollectorException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(root.getType());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(root.getGroupId(), root.getArtifactId(), root.getClassifier(), extension, root.getVersion());
        CollectRequest request = new CollectRequest();
        request.setRoot(new Dependency(aetherArtifact, null));
        return this.collectDependencies(buildingRequest, request);
    }

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, Model root) throws DependencyCollectorException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(root.getPackaging());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(root.getGroupId(), root.getArtifactId(), extension, root.getVersion());
        CollectRequest request = new CollectRequest();
        request.setRoot(new Dependency(aetherArtifact, null));
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        ArrayList<Dependency> aetherDependencies = new ArrayList<Dependency>(root.getDependencies().size());
        for (org.apache.maven.model.Dependency mavenDependency : root.getDependencies()) {
            aetherDependencies.add(Maven30DependencyCollector.toDependency(mavenDependency, typeRegistry));
        }
        request.setDependencies(aetherDependencies);
        if (root.getDependencyManagement() != null) {
            ArrayList<Dependency> aetherManagerDependencies = new ArrayList<Dependency>(root.getDependencyManagement().getDependencies().size());
            for (org.apache.maven.model.Dependency mavenDependency : root.getDependencyManagement().getDependencies()) {
                aetherManagerDependencies.add(Maven30DependencyCollector.toDependency(mavenDependency, typeRegistry));
            }
            request.setManagedDependencies(aetherManagerDependencies);
        }
        return this.collectDependencies(buildingRequest, request);
    }

    private CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, CollectRequest request) throws DependencyCollectorException {
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, buildingRequest.getRemoteRepositories());
        request.setRepositories(aetherRepositories);
        try {
            return new Maven30CollectorResult(this.repositorySystem.collectDependencies(session, request));
        }
        catch (DependencyCollectionException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }

    private static Dependency toDependency(org.apache.maven.model.Dependency mavenDependency, ArtifactTypeRegistry typeRegistry) throws DependencyCollectorException {
        Class[] argClasses = new Class[]{Dependency.class, ArtifactTypeRegistry.class};
        Object[] args = new Object[]{mavenDependency, typeRegistry};
        return (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
    }
}

