/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.functions;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugins.assembly.functions.MavenProjectConsumer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;

public class MavenProjects {
    public static void without(Iterable<MavenProject> source, String packagingType, MavenProjectConsumer consumer) {
        for (MavenProject project : source) {
            if (packagingType.equals(project.getPackaging())) continue;
            consumer.accept(project);
        }
    }

    public static void select(Iterable<MavenProject> source, String packagingType, MavenProjectConsumer consumer) {
        for (MavenProject project : source) {
            if (!packagingType.equals(project.getPackaging())) continue;
            consumer.accept(project);
        }
    }

    public static void select(Iterable<MavenProject> source, String packagingType, MavenProjectConsumer include, MavenProjectConsumer excluded) {
        for (MavenProject project : source) {
            if (packagingType.equals(project.getPackaging())) {
                include.accept(project);
                continue;
            }
            excluded.accept(project);
        }
    }

    @Nullable
    public static Artifact findArtifactByClassifier(MavenProject mavenProject, String classifier) {
        List<Artifact> attachments = mavenProject.getAttachedArtifacts();
        if (attachments != null && !attachments.isEmpty()) {
            for (Artifact attachment : attachments) {
                if (!classifier.equals(attachment.getClassifier())) continue;
                return attachment;
            }
        }
        return null;
    }

    public static MavenProjectConsumer log(final Logger logger) {
        return new MavenProjectConsumer(){

            @Override
            public void accept(MavenProject project) {
                String projectId = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
                logger.debug("Excluding POM-packaging module: " + projectId);
            }
        };
    }

    public static MavenProjectConsumer addTo(final Set<MavenProject> set) {
        return new MavenProjectConsumer(){

            @Override
            public void accept(MavenProject project) {
                set.add(project);
            }
        };
    }
}

