/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.filter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.plugins.assembly.utils.AssemblyFileUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.IOUtil;

@Component(role=ContainerDescriptorHandler.class, hint="file-aggregator", instantiationStrategy="per-lookup")
public class SimpleAggregatingDescriptorHandler
implements ContainerDescriptorHandler,
LogEnabled {
    private final String commentChars = "#";
    private final StringWriter aggregateWriter = new StringWriter();
    private final List<String> filenames = new ArrayList<String>();
    private String filePattern;
    private String outputPath;
    private boolean overrideFilterAction;
    private Logger logger;

    @Override
    public void finalizeArchiveCreation(Archiver archiver) {
        this.checkConfig();
        if (this.outputPath.endsWith("/")) {
            throw new ArchiverException("Cannot write aggregated properties to a directory. You must specify a file name in the outputPath configuration for this handler. (handler: " + this.getClass().getName());
        }
        if (this.outputPath.startsWith("/")) {
            this.outputPath = this.outputPath.substring(1);
        }
        File temp = this.writePropertiesFile();
        this.overrideFilterAction = true;
        archiver.addFile(temp, this.outputPath);
        this.overrideFilterAction = false;
    }

    private File writePropertiesFile() {
        File f;
        OutputStreamWriter writer = null;
        try {
            f = File.createTempFile("maven-assembly-plugin", "tmp");
            f.deleteOnExit();
            writer = AssemblyFileUtils.isPropertyFile(f) ? new OutputStreamWriter((OutputStream)new FileOutputStream(f), "ISO-8859-1") : new OutputStreamWriter(new FileOutputStream(f));
            writer.write("# Aggregated on " + new Date() + " from: ");
            for (String filename : this.filenames) {
                writer.write("\n# " + filename);
            }
            writer.write("\n\n");
            writer.write(this.aggregateWriter.toString());
            ((Writer)writer).close();
            writer = null;
        }
        catch (IOException e) {
            try {
                throw new ArchiverException("Error adding aggregated properties to finalize archive creation. Reason: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
        return f;
    }

    @Override
    public void finalizeArchiveExtraction(UnArchiver unarchiver) {
    }

    @Override
    public List<String> getVirtualFiles() {
        this.checkConfig();
        return Collections.singletonList(this.outputPath);
    }

    @Override
    public boolean isSelected(@Nonnull FileInfo fileInfo) throws IOException {
        this.checkConfig();
        if (this.overrideFilterAction) {
            return true;
        }
        String name = AssemblyFileUtils.normalizeFileInfo(fileInfo);
        if (fileInfo.isFile() && name.matches(this.filePattern)) {
            this.readProperties(fileInfo);
            this.filenames.add(name);
            return false;
        }
        return true;
    }

    private void checkConfig() {
        if (this.filePattern == null || this.outputPath == null) {
            throw new IllegalStateException("You must configure filePattern and outputPath in your containerDescriptorHandler declaration.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProperties(FileInfo fileInfo) throws IOException {
        InputStreamReader reader = null;
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            reader = AssemblyFileUtils.isPropertyFile(fileInfo.getName()) ? new InputStreamReader(fileInfo.getContents(), "ISO-8859-1") : new InputStreamReader(fileInfo.getContents());
            IOUtil.copy((Reader)reader, (Writer)writer);
            writer.close();
            String content = writer.toString();
            writer = null;
            ((Reader)reader).close();
            reader = null;
            this.aggregateWriter.write("\n");
            this.aggregateWriter.write(content);
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close(writer);
        IOUtil.close(reader);
    }

    protected final Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(1, "");
        }
        return this.logger;
    }

    @Override
    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }
}

