/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.plugins.assembly.utils.AssemblyFileUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.util.IOUtil;

abstract class AbstractLineAggregatingHandler
implements ContainerDescriptorHandler {
    private Map<String, List<String>> catalog = new HashMap<String, List<String>>();
    private boolean excludeOverride = false;

    AbstractLineAggregatingHandler() {
    }

    protected abstract String getOutputPathPrefix(FileInfo var1);

    protected abstract boolean fileMatches(FileInfo var1);

    String getEncoding() {
        return "UTF-8";
    }

    @Override
    public void finalizeArchiveCreation(Archiver archiver) {
        ResourceIterator it = archiver.getResources();
        while (it.hasNext()) {
            it.next();
        }
        this.addToArchive(archiver);
    }

    void addToArchive(Archiver archiver) {
        for (Map.Entry<String, List<String>> entry : this.catalog.entrySet()) {
            File f;
            String name = entry.getKey();
            String fname = new File(name).getName();
            PrintWriter writer = null;
            try {
                f = File.createTempFile("assembly-" + fname, ".tmp");
                f.deleteOnExit();
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), this.getEncoding()));
                for (String line : entry.getValue()) {
                    writer.println(line);
                }
                writer.close();
                writer = null;
            }
            catch (IOException e) {
                try {
                    throw new ArchiverException("Error adding aggregated content for: " + fname + " to finalize archive creation. Reason: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
            }
            IOUtil.close(writer);
            this.excludeOverride = true;
            archiver.addFile(f, name);
            this.excludeOverride = false;
        }
    }

    @Override
    public void finalizeArchiveExtraction(UnArchiver unArchiver) {
    }

    @Override
    public List<String> getVirtualFiles() {
        return new ArrayList<String>(this.catalog.keySet());
    }

    @Override
    public boolean isSelected(@Nonnull FileInfo fileInfo) throws IOException {
        if (this.excludeOverride) {
            return true;
        }
        String name = AssemblyFileUtils.normalizeFileInfo(fileInfo);
        if (fileInfo.isFile() && this.fileMatches(fileInfo)) {
            name = this.getOutputPathPrefix(fileInfo) + new File(name).getName();
            List<String> lines = this.catalog.get(name);
            if (lines == null) {
                lines = new ArrayList<String>();
                this.catalog.put(name, lines);
            }
            this.readLines(fileInfo, lines);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readLines(FileInfo fileInfo, List<String> lines) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(fileInfo.getContents(), this.getEncoding()));
            String line = reader.readLine();
            while (line != null) {
                if (!lines.contains(line)) {
                    lines.add(line);
                }
                line = reader.readLine();
            }
            reader.close();
            reader = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close(reader);
    }

    protected final Map<String, List<String>> getCatalog() {
        return this.catalog;
    }

    protected final void setCatalog(Map<String, List<String>> catalog) {
        this.catalog = catalog;
    }
}

