/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils.ssh;

import java.io.ByteArrayOutputStream;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHUtils {
    private static final Logger log = LoggerFactory.getLogger(SSHUtils.class);

    public static void main(String[] args) {
        String[] rs;
        String cmd = "source /etc/profile&&cd /gdsy/dzyw && rm -rf dzywtemp && rm -rf UpDataSoftware*.jar && mkdir -p dzywtemp && mkdir -p dzyw_bak";
        for (String s : rs = cmd.split("&&")) {
            System.out.println("execut:" + s);
        }
    }

    public String execute(String host, String username, String password, String commoand) {
        return this.execute(host, username, password, 22, commoand, 30L);
    }

    public String[] execute(String host, String username, String password, String ... commoand) {
        return this.execute(host, username, password, 22, 30L, commoand);
    }

    public String execute(String host, String username, String password, int port, String commoand) {
        return this.execute(host, username, password, port, commoand, 30L);
    }

    public String[] execute(String host, String username, String password, int port, String ... commoand) {
        return this.execute(host, username, password, port, 30L, commoand);
    }

    public String execute(String host, String username, String password, int port, String commoand, long duration) {
        SshClient client = SshClient.setUpDefaultClient();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        client.start();
        try {
            ConnectFuture cf = client.connect(username, host, port);
            ClientSession session = (ClientSession)((ConnectFuture)cf.verify(60000L)).getSession();
            session.addPasswordIdentity(password);
            session.auth().verify(TimeUnit.SECONDS.toMillis(duration));
            ChannelExec ce = session.createExecChannel(commoand);
            ce.setOut(out);
            ce.setErr(err);
            ce.open();
            Set<ClientChannelEvent> events = ce.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), TimeUnit.SECONDS.toMinutes(10L));
            session.close(false);
            if (events.contains((Object)ClientChannelEvent.TIMEOUT)) {
                throw new RuntimeException(" \u547d\u4ee4 \u6267\u884c\u8d85\u65f6 10\u5206\u949f");
            }
            client.stop();
            client.close();
            out.close();
            err.close();
            ce.close();
        }
        catch (Exception e) {
            log.error("execute error", e);
            return "Connection error";
        }
        log.info("out:" + out.toString());
        log.info("err:" + err.toString());
        return out.toString();
    }

    public String[] execute(String host, String username, String password, int port, long duration, String ... commoand) {
        SshClient client = SshClient.setUpDefaultClient();
        String[] result = new String[commoand.length];
        client.start();
        try {
            ConnectFuture cf = client.connect(username, host, port);
            ClientSession session = (ClientSession)((ConnectFuture)cf.verify(60000L)).getSession();
            session.addPasswordIdentity(password);
            session.auth().verify(TimeUnit.SECONDS.toMillis(duration));
            for (int i = 0; i < commoand.length; ++i) {
                log.info("execute(waitFor 60):" + commoand[i]);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                ChannelExec ce = session.createExecChannel(commoand[i]);
                ce.setOut(out);
                ce.setErr(err);
                ce.open();
                Set<ClientChannelEvent> events = ce.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), TimeUnit.SECONDS.toMinutes(10L));
                if (events.contains((Object)ClientChannelEvent.TIMEOUT)) {
                    throw new RuntimeException(" \u547d\u4ee4 \u6267\u884c\u8d85\u65f6 10 \u5206\u949f");
                }
                out.close();
                err.close();
                ce.close();
                log.info("out:" + out.toString());
                log.info("err:" + err.toString());
                result[i] = out.toString();
            }
            session.close(false);
            client.stop();
            client.close();
        }
        catch (Exception e) {
            log.error("execute error", e);
            return null;
        }
        return result;
    }

    public String[][] resultConverter(String result) {
        String[] rows = result.split("\n");
        String[][] results = new String[rows.length][];
        for (int i = 0; i < rows.length; ++i) {
            String[] columns = StringUtils.split(rows[i], " ");
            results[i] = columns;
        }
        return results;
    }
}

