/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellUtils {
    private static final Logger log = LoggerFactory.getLogger(ShellUtils.class);

    public String executels(String ... commoand) throws Exception {
        StringBuffer buffer = new StringBuffer();
        for (String cmd : commoand) {
            buffer.append(cmd + "");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(commoand);
        String output = null;
        Process process = processBuilder.start();
        int exitCode = process.waitFor();
        if (exitCode == 0) {
            InputStream inputStream = process.getInputStream();
            output = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
        } else {
            log.error("Command execution failed with exit code: " + exitCode + "\n" + buffer.toString());
        }
        return output;
    }

    public String executels(String command) {
        StringBuffer output = new StringBuffer();
        ProcessBuilder builder = new ProcessBuilder("/bin/sh", "-c", command);
        try {
            String line;
            Process process = builder.start();
            log.info("execution command: " + command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
                log.info(line);
            }
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            log.error("exec command[" + command + "] failed:" + e.getMessage(), e);
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String syncfile(String command, String serverIp) {
        StringBuffer sb = new StringBuffer();
        Runtime runtime = Runtime.getRuntime();
        Process pro = null;
        BufferedReader input = null;
        PrintWriter output = null;
        if (null == runtime) {
            return null;
        }
        try {
            String line;
            pro = runtime.exec(String.format(command, serverIp));
            input = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            while ((line = input.readLine()) != null) {
                sb.append(line).append("\n");
            }
            log.info("\u670d\u52a1\u5668\u540c\u6b65\u5b8c\u6210-{}", (Object)serverIp);
        }
        catch (IOException ex) {
            log.error("Exception:" + ex.getMessage(), ex);
        }
        finally {
            try {
                if (null != input) {
                    input.close();
                }
            }
            catch (IOException e) {
                log.error("Exception:" + e.getMessage(), e);
            }
            try {
                if (null != output) {
                    output.close();
                }
            }
            catch (Exception e) {
                log.error("Exception:" + e.getMessage(), e);
            }
        }
        return sb.toString();
    }

    public void execute(final String cmd) {
        try {
            final Process process = Runtime.getRuntime().exec(cmd);
            log.info("start run cmd=" + cmd);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = null;
                    try {
                        while ((line = in.readLine()) != null) {
                            log.info("o: " + line);
                        }
                    }
                    catch (IOException e) {
                        log.error("finish run cmd=" + cmd + " error=" + e.getMessage(), e);
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            log.error("finish run cmd=" + cmd + " error=" + e.getMessage(), e);
                        }
                    }
                }
            }.start();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String line = null;
                    try {
                        while ((line = err.readLine()) != null) {
                            log.info("e: " + line);
                        }
                    }
                    catch (IOException e) {
                        log.error("finish run cmd=" + cmd + " error=" + e.getMessage(), e);
                    }
                    finally {
                        try {
                            err.close();
                        }
                        catch (IOException e) {
                            log.error("finish run cmd=" + cmd + " error=" + e.getMessage(), e);
                        }
                    }
                }
            }.start();
            process.waitFor();
            log.info("finish run cmd=" + cmd);
        }
        catch (Exception e) {
            log.error("finish run cmd=" + cmd + " error=" + e.getMessage(), e);
        }
    }
}

