/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils.scp;

import info.gdsy.utils.crypto.AESUtils;
import info.gdsy.utils.scp.bo.SCPBO;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.client.ScpClientCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCPUtils {
    private static final Logger log = LoggerFactory.getLogger(SCPUtils.class);

    public void scpFile(SCPBO scpbo, String ... locationfile) throws Exception {
        long startTime = System.currentTimeMillis();
        SshClient client = SshClient.setUpDefaultClient();
        client.start();
        ClientSession session = (ClientSession)((ConnectFuture)client.connect(scpbo.getUsername(), scpbo.getHost(), scpbo.getPort()).verify()).getSession();
        session.addPasswordIdentity(AESUtils.decrypt(scpbo.getPassword()));
        boolean isSuccess = ((AuthFuture)session.auth().verify()).isSuccess();
        if (isSuccess) {
            long middleTime = System.currentTimeMillis();
            log.info("Connect host cost time: " + (double)(middleTime - startTime) / 1000.0 + "s.");
            ScpClientCreator creator = ScpClientCreator.instance();
            ScpClient scpClient = creator.createScpClient(session);
            if (scpbo.isUpload()) {
                log.info("upload:" + scpbo.getLocationPath() + " Scp beginning.");
                scpClient.upload(scpbo.getLocationPath(), scpbo.getRemotePath(), ScpClient.Option.Recursive);
                log.info("upload:" + scpbo.getLocationPath() + ":Scp finished.");
                if (locationfile != null) {
                    for (String s : locationfile) {
                        log.info(s + "\uff1aScp beginning.");
                        scpClient.upload(s, scpbo.getRemotePath(), ScpClient.Option.Recursive);
                        log.info(s + ":Scp finished.");
                    }
                }
            } else {
                log.info("download:" + scpbo.getRemotePath() + " Scp beginning.");
                scpClient.download(scpbo.getRemotePath(), scpbo.getLocationPath(), ScpClient.Option.Recursive);
                log.info("download:" + scpbo.getRemotePath() + " Scp finished.");
                if (locationfile != null) {
                    for (String s : locationfile) {
                        log.info("download:" + s + "\uff1aScp beginning.");
                        scpClient.download(scpbo.getRemotePath(), s, ScpClient.Option.Recursive);
                        log.info("download:" + s + ":Scp finished.");
                    }
                }
            }
            if (scpClient != null) {
                scpClient = null;
            }
            if (session != null && session.isOpen()) {
                session.close();
            }
            if (client != null && client.isOpen()) {
                client.stop();
                client.close();
            }
        }
        long endTime = System.currentTimeMillis();
        log.info("Total Cost time: " + (double)(endTime - startTime) / 1000.0 + "s.");
    }

    public void scpFile(SCPBO scpbo) throws Exception {
        this.scpFile(scpbo, null);
    }

    public void saveNas(String path, String remotedir, String server_ip) throws Exception {
        SCPBO sb = new SCPBO();
        sb.setHost(StringUtils.isNotEmpty(server_ip) ? server_ip : "dzyw.gdsy.info");
        sb.setPort(8521);
        sb.setUsername("liudl");
        sb.setPassword("OpAc6kYdmdqufUR/FGQfbg==");
        sb.setLocationPath(path);
        sb.setRemotePath(remotedir);
        this.scpFile(sb);
    }

    public void savelogstoNas(String path, String server_ip) throws Exception {
        this.saveNas(path, "/var/ftp/dzyw/logs/", server_ip);
    }

    public void saveNas(String path, String remotedir) throws Exception {
        this.saveNas(path, remotedir, "dzyw.gdsy.info");
    }

    public void saveNas(String path) throws Exception {
        this.saveNas(path, "/var/ftp/dzyw/temp/", "dzyw.gdsy.info");
    }
}

