/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils.quartz;

import info.gdsy.utils.quartz.CronExpression;
import info.gdsy.utils.quartz.TaskParam;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCron
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(TaskCron.class);
    private static List<TaskParam> ls = new ArrayList<TaskParam>();
    public static BlockingQueue<TaskParam> task = new LinkedBlockingQueue<TaskParam>(50);
    public static Map<String, TaskParam> taskCronMap = new HashMap<String, TaskParam>();

    @Override
    public void run() {
        this.initCron();
        while (true) {
            if (ls.size() > 0) {
                TaskParam taskParam = ls.get(0);
                Long sleepTime = taskParam.getDate().getTime() - System.currentTimeMillis();
                try {
                    Thread.sleep(sleepTime > 0L ? sleepTime : 0L);
                    log.info("add Task:" + taskParam.getTaskName() + "\u3001TaskSize:" + task.size());
                    task.put(taskParam);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), e);
                }
                this.restSleep(taskParam);
                Collections.sort(ls);
                continue;
            }
            try {
                log.info("Task is null sleep 10S \u3001 ls.size():" + ls.size() + ",task.size():" + task.size() + ",taskCronMap.size():" + taskCronMap.size());
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void restSleep(TaskParam taskParam) {
        Date now = new Date();
        Date nextTime = null;
        try {
            nextTime = new CronExpression(taskParam.getCron()).getNextValidTimeAfter(now);
            log.info("reset:" + taskParam.getTaskName() + " Exec Task Next Time:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(nextTime) + "\u3001time remaining:" + this.format(nextTime.getTime() - now.getTime()));
            taskParam.setDate(nextTime);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), e);
        }
    }

    private void initCron() {
        Date now = new Date();
        HashMap<String, String> taskKey = new HashMap<String, String>();
        for (String key : taskCronMap.keySet()) {
            TaskParam taskParam = taskCronMap.get(key);
            try {
                Date nextTime = new CronExpression(taskParam.getCron()).getNextValidTimeAfter(now);
                taskParam.setDate(nextTime);
                taskKey.put(taskParam.getTaskName() + nextTime.getTime(), key);
                ls.add(taskParam);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), e);
            }
        }
        Collections.sort(ls);
        for (TaskParam taskParam : ls) {
            log.info("init: [" + taskParam.getTaskName() + "]" + (String)taskKey.get(taskParam.getTaskName() + taskParam.getDate().getTime()) + "  Exec Task Next Time:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(taskParam.getDate()) + "\u3001time remaining:" + this.format(taskParam.getDate().getTime() - now.getTime()));
        }
    }

    private String format(long ms) {
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        int dd = hh * 24;
        long day = ms / (long)dd;
        long hour = (ms - day * (long)dd) / (long)hh;
        long minute = (ms - day * (long)dd - hour * (long)hh) / (long)mi;
        long second = (ms - day * (long)dd - hour * (long)hh - minute * (long)mi) / (long)ss;
        long milliSecond = ms - day * (long)dd - hour * (long)hh - minute * (long)mi - second * (long)ss;
        String strDay = day < 10L ? "0" + day : "" + day;
        String strHour = hour < 10L ? "0" + hour : "" + hour;
        String strMinute = minute < 10L ? "0" + minute : "" + minute;
        String strSecond = second < 10L ? "0" + second : "" + second;
        String strMilliSecond = milliSecond < 10L ? "0" + milliSecond : "" + milliSecond;
        strMilliSecond = milliSecond < 100L ? "0" + strMilliSecond : "" + strMilliSecond;
        return strDay + " " + strHour + ":" + strMinute + ":" + strSecond + " " + strMilliSecond;
    }
}

