/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils.pdf;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFUtils {
    private static final Logger log = LoggerFactory.getLogger(PDFUtils.class);

    public static void main(String[] args) {
        PDFUtils pdfUtils = new PDFUtils();
        String pdfFileName = "D:\\syxk\\\u516c\u53f8\u8d44\u6599\\\u7535\u5b50\u5408\u540c\\\u9500\u552e\u5408\u540c\\\u5e7f\u5dde\u535a\u8bda\u4fe1\u606f\u79d1\u6280\u6709\u9650\u516c\u53f8\\\u7535\u5b50\u79d1\u6280\u5927\u5b66\u4e2d\u5c71\u5b66\u9662\\\u7535\u5b50\u79d1\u6280\u5927\u5b66\u4e2d\u5c71\u5b66\u96621.pdf";
        try {
            System.out.println(pdfUtils.readText(pdfFileName));
            pdfUtils.readImage(pdfFileName, "D:\\syxk\\\u516c\u53f8\u8d44\u6599\\\u516c\u53f8LOGO\u53ca\u4f7f\u7528\u89c4\u8303\\\u54c1\u724c\u8272");
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    public String readText(String filename) throws Exception {
        PDDocument doc = PDDocument.load(new FileInputStream(filename));
        PDFTextStripper text = new PDFTextStripper();
        String FinalText = text.getText(doc);
        doc.close();
        return FinalText;
    }

    public void readImage(String filename, String imagePath) throws Exception {
        PDDocument doc = PDDocument.load(new FileInputStream(filename));
        PDPage pageOne = doc.getPage(0);
        PDResources resources = pageOne.getResources();
        Iterable<COSName> xObjectNames = resources.getXObjectNames();
        xObjectNames.forEach(item -> {
            int Count2 = 0;
            try {
                PDXObject xObject = resources.getXObject((COSName)item);
                System.out.println(item.getName());
                if (xObject instanceof PDImageXObject) {
                    PDImageXObject imgobject = (PDImageXObject)xObject;
                    BufferedImage image = imgobject.getImage();
                    String uuid = UUID.randomUUID().toString();
                    ImageIO.write((RenderedImage)image, "png", new File(imagePath + File.separator + uuid + ".png"));
                    System.out.println("ImageSaved" + Count2);
                    ++Count2;
                }
            }
            catch (IOException e) {
                System.out.println("\u56fe\u7247\u4fdd\u5b58\u51fa\u9519");
                e.printStackTrace();
            }
        });
    }
}

