/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils.image;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeUtils {
    private static final Logger log = LoggerFactory.getLogger(QRCodeUtils.class);
    private static final String CHARSET = "utf-8";
    private static final String FORMAT_NAME = "JPG";
    private static final int QRCODE_SIZE = 3189;
    private static final int WIDTH = 640;
    private static final int HEIGHT = 640;

    public static void main(String[] args) throws Exception {
        QRCodeUtils qrcodeUtils = new QRCodeUtils();
        String text = "www.gdsyxk.com";
        String imagePath = "D:\\syxk\\\u516c\u53f8\u8d44\u6599\\\u516c\u53f8LOGO\u53ca\u4f7f\u7528\u89c4\u8303\\\u54c1\u724c\u8272\\LOGO_logo-sy.png";
        String destPath = "D:\\syxk\\\u516c\u53f8\u8d44\u6599\\\u516c\u53f8LOGO\u53ca\u4f7f\u7528\u89c4\u8303\\\u54c1\u724c\u8272";
        String fileName = null;
        try {
            fileName = qrcodeUtils.encode(text, imagePath, destPath, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String str = qrcodeUtils.decode(new File("D:\\syxk\\\u516c\u53f8\u8d44\u6599\\\u516c\u53f8LOGO\u53ca\u4f7f\u7528\u89c4\u8303\\\u54c1\u724c\u8272\\" + fileName));
        System.out.println(str);
    }

    private BufferedImage createImage(String content, String imgPath, boolean needCompress) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 3189, 3189, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        if (imgPath == null || "".equals(imgPath)) {
            return image;
        }
        this.insertImage(image, imgPath, needCompress);
        return image;
    }

    private void insertImage(BufferedImage source, String imgPath, boolean needCompress) throws Exception {
        File file = new File(imgPath);
        if (!file.exists()) {
            System.err.println("" + imgPath + "   \u8be5\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return;
        }
        Image src = ImageIO.read(new File(imgPath));
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        if (needCompress) {
            if (width > 640) {
                width = 640;
            }
            if (height > 640) {
                height = 640;
            }
            Image image = src.getScaledInstance(width, height, 4);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            src = image;
        }
        Graphics2D graph = source.createGraphics();
        int x = (3189 - width) / 2;
        int y = (3189 - height) / 2;
        int tmp = 120;
        int arc = 120;
        graph.setColor(Color.WHITE);
        graph.fillRoundRect(x - tmp, y - tmp, width + tmp * 2, width + tmp * 2, arc, arc);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x - tmp, y - tmp, width + tmp * 2, width + tmp * 2, arc, arc);
        graph.setStroke(new BasicStroke(6.0f));
        graph.setColor(new Color(0, 166, 254));
        graph.draw(shape);
        graph.drawImage(src, x, y, width, height, null);
        graph.dispose();
    }

    public String encode(String content, String imgPath, String destPath, boolean needCompress) throws Exception {
        BufferedImage image = this.createImage(content, imgPath, needCompress);
        this.mkdirs(destPath);
        String file = UUID.randomUUID().toString() + ".jpg";
        ImageIO.write((RenderedImage)image, FORMAT_NAME, new File(destPath + "/" + file));
        return file;
    }

    public void encode(String content, String imgPath, String destPath, String destName, boolean needCompress) throws Exception {
        BufferedImage image = this.createImage(content, imgPath, needCompress);
        this.mkdirs(destPath);
        ImageIO.write((RenderedImage)image, FORMAT_NAME, new File(destPath + "/" + destName));
    }

    public void mkdirs(String destPath) {
        File file = new File(destPath);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
    }

    public String encode(String content, String imgPath, String destPath) throws Exception {
        return this.encode(content, imgPath, destPath, false);
    }

    public String encode(String content, String destPath, boolean needCompress) throws Exception {
        return this.encode(content, null, destPath, needCompress);
    }

    public String encode(String content, String destPath) throws Exception {
        return this.encode(content, null, destPath, false);
    }

    public void encode(String content, String imgPath, OutputStream output, boolean needCompress) throws Exception {
        BufferedImage image = this.createImage(content, imgPath, needCompress);
        ImageIO.write((RenderedImage)image, FORMAT_NAME, output);
    }

    public void encode(String content, OutputStream output) throws Exception {
        this.encode(content, null, output, false);
    }

    public String decode(File file) throws Exception {
        String resultStr = null;
        try {
            BufferedImage image = ImageIO.read(file);
            if (image == null) {
                return null;
            }
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));
            Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
            Result result = new MultiFormatReader().decode(bitmap, hints);
            resultStr = result.getText();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return resultStr;
    }

    public String decode(String path) throws Exception {
        return this.decode(new File(path));
    }
}

