/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import info.gdsy.utils.http.HttpSercicesI;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServices
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(HttpServices.class);
    private int port;
    private HttpSercicesI httpSercicesI;

    public HttpServices(int port, HttpSercicesI httpSercicesI) {
        this.port = port;
        this.httpSercicesI = httpSercicesI;
    }

    @Override
    public void run() {
        try {
            InetSocketAddress addr = new InetSocketAddress(this.port);
            HttpServer httpServer = HttpServer.create(addr, 0);
            httpServer.createContext("/", new HttpHandler(){

                @Override
                public void handle(HttpExchange httpExchange) throws IOException {
                    String requestMethod = httpExchange.getRequestMethod();
                    byte[] respContents = "200".getBytes("UTF-8");
                    httpExchange.getResponseHeaders().add("Content-Type", "text/html;charset=UTF-8");
                    URI requestedUri = httpExchange.getRequestURI();
                    String query = requestedUri.getRawQuery();
                    log.info("get-query:" + query);
                    if (requestMethod.equalsIgnoreCase("GET")) {
                        respContents = HttpServices.this.httpSercicesI.handleGet(httpExchange, query).getBytes("UTF-8");
                    } else if (requestMethod.equalsIgnoreCase("POST")) {
                        String s = IOUtils.toString(httpExchange.getRequestBody());
                        respContents = HttpServices.this.httpSercicesI.handlePost(httpExchange, query, s).getBytes("UTF-8");
                    }
                    httpExchange.sendResponseHeaders(200, respContents.length);
                    httpExchange.getResponseBody().write(respContents);
                    httpExchange.close();
                }
            });
            httpServer.start();
            log.info("http\u670d\u52a1\u542f\u52a8\u3001\u7aef\u53e3:" + this.port);
        }
        catch (Exception e) {
            log.error("HttpServices Exception", e);
        }
    }
}

