/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils.file;

import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getFileMD5(String path) throws Exception {
        try (FileInputStream fis = new FileInputStream(new File(path));){
            int bytesRead;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) != -1) {
                md.update(buffer, 0, bytesRead);
            }
            byte[] digestBytes = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : digestBytes) {
                sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
            }
            String string = sb.toString();
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

