/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POIUtils {
    private static final Logger log = LoggerFactory.getLogger(POIUtils.class);

    public static void main(String[] args) {
        POIUtils poiUtils = new POIUtils();
        String absolutePath = "D:\\syxk\\workSpace\\Tools\\invoiceTools\\invoicetools\\template\\dataTemplate.xlsx";
        try {
            FileInputStream fis = new FileInputStream(new File(absolutePath));
            XSSFWorkbook workbook = new XSSFWorkbook(fis);
            Map<String, String> templateMap = poiUtils.getContent(workbook, 0, "A1");
            System.out.println(templateMap.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Object[]> getContent(XSSFWorkbook workbook, Integer sheetIndex, String startCellName, String endCellName) {
        XSSFSheet xssfSheet = workbook.getSheet(workbook.getSheetName(sheetIndex));
        boolean isextend = true;
        CellAddress startCellAddress = new CellAddress(startCellName);
        CellAddress endCellAddress = new CellAddress(endCellName);
        Integer startRow = startCellAddress.getRow();
        Integer startColumn = startCellAddress.getColumn();
        Integer endcolumn = endCellAddress.getColumn();
        Integer len = endcolumn - startCellAddress.getColumn() + 1;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        while (isextend) {
            XSSFRow xssfRow = xssfSheet.getRow(startRow);
            if (xssfRow != null) {
                Object[] args = new Object[len.intValue()];
                int blanknum = 0;
                int j = 0;
                for (int i = startColumn.intValue(); i <= endcolumn; ++i) {
                    XSSFCell xssfCell = xssfRow.getCell(i);
                    if (xssfCell == null) {
                        isextend = false;
                    } else if (xssfCell.getCellType() == CellType.NUMERIC) {
                        args[j] = xssfCell.getNumericCellValue();
                    } else if (xssfCell.getCellType() == CellType.STRING) {
                        args[j] = xssfCell.getStringCellValue();
                    } else if (xssfCell.getCellType() == CellType.FORMULA) {
                        args[j] = xssfCell.getArrayFormulaRange();
                    } else if (xssfCell.getCellType() == CellType.BLANK) {
                        args[j] = null;
                        isextend = ++blanknum != len;
                    } else {
                        System.out.println((Object)xssfCell.getCellType());
                    }
                    ++j;
                }
                list.add(args);
                Integer n = startRow;
                Integer n2 = startRow = Integer.valueOf(startRow + 1);
                continue;
            }
            isextend = false;
        }
        return list;
    }

    public Map<String, String> getContent(XSSFWorkbook workbook, Integer sheetIndex, String startCellName) {
        XSSFSheet xssfSheet = workbook.getSheet(workbook.getSheetName(sheetIndex));
        boolean isextend = true;
        CellAddress startCellAddress = new CellAddress(startCellName);
        Integer startRow = startCellAddress.getRow();
        Integer startColumn = startCellAddress.getColumn();
        ArrayList list = new ArrayList();
        HashMap<String, String> configMap = new HashMap<String, String>();
        while (isextend) {
            XSSFRow xssfRow = xssfSheet.getRow(startRow);
            if (xssfRow != null) {
                boolean blanknum = false;
                for (int i = startColumn.intValue(); i <= xssfRow.getLastCellNum(); ++i) {
                    XSSFCell xssfCell = xssfRow.getCell(i);
                    if (xssfCell == null) {
                        isextend = false;
                        continue;
                    }
                    if (xssfCell.getCellType() == CellType.NUMERIC) {
                        configMap.put(xssfCell.getNumericCellValue() + "", xssfCell.getAddress().formatAsString());
                        continue;
                    }
                    if (xssfCell.getCellType() == CellType.STRING) {
                        configMap.put(xssfCell.getStringCellValue(), xssfCell.getAddress().formatAsString());
                        continue;
                    }
                    if (xssfCell.getCellType() == CellType.FORMULA) {
                        configMap.put(xssfCell.getArrayFormulaRange() + "", xssfCell.getAddress().formatAsString());
                        continue;
                    }
                    if (xssfCell.getCellType() == CellType.BLANK) {
                        isextend = false;
                        continue;
                    }
                    log.warn((Object)((Object)xssfCell.getCellType()) + " is not supported");
                }
                Integer n = startRow;
                Integer n2 = startRow = Integer.valueOf(startRow + 1);
                continue;
            }
            isextend = false;
        }
        return configMap;
    }

    public int writeExcel(XSSFWorkbook workbook, Integer sheetIndex, Map<String, String> excelTemplate, List<Map<String, String>> dateMapls) throws Exception {
        XSSFCell xssfCell;
        CellAddress startCellAddress;
        int i = 0;
        XSSFSheet xssfSheet = workbook.getSheetAt(sheetIndex);
        XSSFRow xssfRow = xssfSheet.getRow(i);
        for (String string : excelTemplate.keySet()) {
            String cellName = excelTemplate.get(string);
            String value = excelTemplate.get(string);
            String content = string.substring(string.indexOf("=") + 1, string.length() - 1);
            startCellAddress = new CellAddress(cellName);
            xssfCell = xssfRow.createCell(startCellAddress.getColumn());
            xssfCell.setCellValue(content);
        }
        for (Map map : dateMapls) {
            xssfRow = xssfSheet.createRow(++i);
            for (String key : map.keySet()) {
                String cellName = excelTemplate.get("#{" + key + "}");
                if (!StringUtils.isNotEmpty(cellName)) continue;
                startCellAddress = new CellAddress(cellName);
                xssfCell = xssfRow.createCell(startCellAddress.getColumn());
                xssfCell.setCellValue((String)map.get(key));
            }
        }
        return i;
    }

    public void writeExcel(XSSFWorkbook workbook, String reportFileName) throws Exception {
        FileOutputStream out = new FileOutputStream(new File(reportFileName));
        workbook.write(out);
        workbook.close();
        out.close();
    }
}

