/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;

public class UnicodeUtils {
    public static void main(String[] args) {
        byte[] utfBytes;
        UnicodeUtils unicodeUtils = new UnicodeUtils();
        System.out.println(unicodeUtils.gbEncoding("\u53d1\u9001\u4e2d\u6587\u77ed\u4fe1\uff0c\u4e0d\u77e5\u9053\u4f60\u4eec\u80fd\u63a5\u6536\u5230\u591a\u5c11\uff0c\u80fd\u7ffb\u8bd1\u591a\u5c11?"));
        for (byte c : utfBytes = "\u5b87\u97f3\u5929\u4e0b".getBytes(Charset.forName("GBK"))) {
            System.out.println(c);
        }
        System.out.println(unicodeUtils.unicodeToStr("53D190014E2D"));
        System.out.println(unicodeUtils.ncrtoString("&#20013;&#25991;&#27979;&#35797;&#21568;"));
    }

    public byte[] mergeBytes(byte[] ... values) {
        int lengthByte = 0;
        for (byte[] value : values) {
            lengthByte += value.length;
        }
        byte[] allBytes = new byte[lengthByte];
        int countLength = 0;
        for (byte[] b : values) {
            System.arraycopy(b, 0, allBytes, countLength, b.length);
            countLength += b.length;
        }
        return allBytes;
    }

    public byte[] intToBytes2(int value) {
        byte[] b = new byte[4];
        b[0] = (byte)((value & 0xFF00) >> 8);
        b[1] = (byte)(value & 0xFF);
        return b;
    }

    public byte[] intToBytes(int value) {
        byte[] b = new byte[4];
        b[3] = (byte)((value & 0xFF000000) >> 24);
        b[2] = (byte)((value & 0xFF0000) >> 16);
        b[1] = (byte)((value & 0xFF00) >> 8);
        b[0] = (byte)(value & 0xFF);
        return b;
    }

    public String gbEncoding(String gbString) {
        char[] utfBytes = gbString.toCharArray();
        String unicodeBytes = "";
        for (int i = 0; i < utfBytes.length; ++i) {
            String hexB = Integer.toHexString(utfBytes[i]);
            if (hexB.length() <= 2) {
                hexB = "00" + hexB;
            }
            unicodeBytes = unicodeBytes + hexB;
        }
        return unicodeBytes;
    }

    public String ncrtoString(String str) {
        StringBuffer sb = new StringBuffer();
        String myString = str.replace("&#", "");
        String[] strs = StringUtils.substringsBetween(str, "&#", ";");
        String[] keys = new String[strs.length];
        String[] values = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            char c = (char)Integer.parseInt(strs[i]);
            String s = c + "";
            keys[i] = "&#" + strs[i] + ";";
            values[i] = s;
        }
        return StringUtils.replaceEach(str, keys, values);
    }

    public String unicodeToStr(String unicode) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < unicode.length() / 4; ++i) {
            String str = unicode.substring(i * 4, (i + 1) * 4);
            int index = Integer.parseInt(str, 16);
            sb.append((char)index);
        }
        return sb.toString();
    }
}

