/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils;

import info.gdsy.utils.crypto.AESUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);

    public Document readconfig(String filename) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = null;
        log.info("\u641c\u7d22\u6587\u4ef6: \u5728\u76ee\u5f55\uff1a" + SystemUtils.getUserDir().getAbsolutePath() + "\u3001\u641c\u7d22\u6587\u4ef6\uff1a" + filename);
        File file = FileUtils.getFile(SystemUtils.getUserDir().getAbsolutePath(), filename);
        if (!file.exists()) {
            log.info("Corresponding file not found; expanding search scope to configuration files. ");
            Path path = this.searchConfig(filename);
            if (path != null) {
                file = path.toFile();
                log.info("File " + path + " retrieved.");
                document = reader.read(file);
            } else {
                log.info("loader jar config SystemConfig.xml");
                InputStream systemInput = ConfigUtils.class.getResourceAsStream(filename);
                document = reader.read(systemInput);
            }
        } else {
            log.info("loader out config SystemConfig.xml");
            document = reader.read(file);
        }
        return document;
    }

    public Properties readProperties(String filename) throws Exception {
        Properties pro = new Properties();
        log.info("\u641c\u7d22\u6587\u4ef6: \u5728\u76ee\u5f55\uff1a" + SystemUtils.getUserDir().getAbsolutePath() + "\u3001\u641c\u7d22\u6587\u4ef6\uff1a" + filename + ".properties");
        File file = FileUtils.getFile(SystemUtils.getUserDir().getAbsolutePath(), filename + ".properties");
        if (file.exists()) {
            try {
                log.info("loader out config " + filename + ".properties");
                FileInputStream systemInput = new FileInputStream(file);
                pro.load(systemInput);
                this.decryptpw(filename, pro);
            }
            catch (Exception ex) {
                log.error("loader out config " + filename + ".properties loader error");
            }
        } else {
            log.info("loader jar config " + filename + ".properties");
            try {
                InputStream id = ConfigUtils.class.getClassLoader().getResourceAsStream(filename + ".properties");
                pro.load(id);
                this.decryptpw(filename, pro);
                return pro;
            }
            catch (Exception ex) {
                log.error(filename + ".properties loader jar not found ");
            }
        }
        return pro;
    }

    private void decryptpw(String filename, Properties pro) {
        if (pro.containsKey("isEncrypted")) {
            if (pro.getProperty("isEncrypted").equals("true")) {
                log.info(filename + ".properties open Encrypted ");
                if (pro.containsKey("password")) {
                    pro.setProperty("password", AESUtils.decrypt(pro.get("password").toString()));
                } else if (pro.containsKey("dataSource.password")) {
                    pro.setProperty("dataSource.password", AESUtils.decrypt(pro.get("dataSource.password").toString()));
                }
            }
            pro.remove("isEncrypted");
        }
    }

    public Path searchConfig(String fileName) throws IOException {
        return this.searchConfigRecursive(Paths.get(System.getProperty("user.dir"), new String[0]), fileName);
    }

    private Path searchConfigRecursive(Path currentDir, String fileName) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(currentDir);){
            for (Path path : stream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Path result = this.searchConfigRecursive(path, fileName);
                    if (result == null) continue;
                    Path path2 = result;
                    return path2;
                }
                if (!path.getFileName().toString().equals(fileName)) continue;
                Path path3 = path.toAbsolutePath();
                return path3;
            }
        }
        return null;
    }
}

