/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.utils;

import com.aliyun.alidns20150109.Client;
import com.aliyun.alidns20150109.models.AddDomainRecordRequest;
import com.aliyun.alidns20150109.models.AddDomainRecordResponse;
import com.aliyun.alidns20150109.models.DeleteDomainRecordRequest;
import com.aliyun.alidns20150109.models.DeleteDomainRecordResponse;
import com.aliyun.alidns20150109.models.DescribeDomainRecordInfoRequest;
import com.aliyun.alidns20150109.models.DescribeDomainRecordInfoResponse;
import com.aliyun.alidns20150109.models.SetDomainRecordStatusRequest;
import com.aliyun.alidns20150109.models.UpdateDomainRecordRequest;
import com.aliyun.alidns20150109.models.UpdateDomainRecordResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import info.gdsy.bean.bo.DomainRecord;
import info.gdsy.utils.shell.ShellUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliDNSUtil {
    private static final Logger log = LoggerFactory.getLogger(AliDNSUtil.class);

    public Client createClient(String sccessKeyId, String accessKeySecret) throws Exception {
        Config config = new Config().setAccessKeyId(sccessKeyId).setAccessKeySecret(accessKeySecret);
        config.endpoint = "alidns.cn-shenzhen.aliyuncs.com";
        return new Client(config);
    }

    public void setDomainRecordStatus(DomainRecord domainRecord) throws Exception {
        Client client = this.createClient(domainRecord.getAccesskeyid(), domainRecord.getAccesskeysecret());
        SetDomainRecordStatusRequest setDomainRecordStatusRequest = new SetDomainRecordStatusRequest().setRecordId(domainRecord.getRecordId()).setStatus(domainRecord.getStatus());
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            client.setDomainRecordStatusWithOptions(setDomainRecordStatusRequest, runtime);
        }
        catch (Exception ex) {
            log.error(Common.assertAsString(ex.getMessage()), ex);
        }
    }

    public void getDomainRecord(DomainRecord domainRecord) throws Exception {
        Client client = this.createClient(domainRecord.getAccesskeyid(), domainRecord.getAccesskeysecret());
        DescribeDomainRecordInfoRequest describeDomainRecordInfoRequest = new DescribeDomainRecordInfoRequest();
        describeDomainRecordInfoRequest.setRecordId(domainRecord.recordId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            DescribeDomainRecordInfoResponse response = client.describeDomainRecordInfoWithOptions(describeDomainRecordInfoRequest, runtime);
            domainRecord.setRecordId(response.body.recordId);
            domainRecord.setDomainName(response.body.domainName);
            domainRecord.setType(response.body.type);
            domainRecord.setValue(response.body.value);
            domainRecord.setRR(response.body.RR);
        }
        catch (TeaException error) {
            log.error(error.getMessage());
            log.error(Common.assertAsString(error.message));
        }
        catch (Exception _error) {
            log.error(_error.getMessage());
            log.error("getDomainRecord:" + domainRecord.recordId + "\u3001RR:" + domainRecord.getRR() + " is error. message:" + _error.getMessage(), _error);
        }
    }

    public String addDomainRecord(DomainRecord domainRecord) throws Exception {
        log.info("adding domain record:" + domainRecord.getRR() + ":" + domainRecord.getValue());
        Client client = this.createClient(domainRecord.getAccesskeyid(), domainRecord.getAccesskeysecret());
        AddDomainRecordRequest addDomainRecordRequest = new AddDomainRecordRequest().setDomainName(domainRecord.domainName).setType(domainRecord.type).setValue(domainRecord.value).setTTL(domainRecord.TTL).setRR(domainRecord.RR);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            AddDomainRecordResponse response = client.addDomainRecordWithOptions(addDomainRecordRequest, runtime);
            log.info("addDomainRecord get recordId:" + response.body.recordId);
            return response.body.recordId;
        }
        catch (Exception ex) {
            log.error(domainRecord.getRR() + "." + domainRecord.getDomainName() + ",value:" + domainRecord.value + "," + Common.assertAsString(ex.getMessage()), ex);
            return null;
        }
    }

    public void updateDomeainRecord(DomainRecord domainRecord) throws Exception {
        Client client = this.createClient(domainRecord.getAccesskeyid(), domainRecord.getAccesskeysecret());
        log.info("update domain record:" + domainRecord.getRR() + ":" + domainRecord.getValue() + ",type:" + domainRecord.type);
        UpdateDomainRecordRequest updateDomainRecordRequest = new UpdateDomainRecordRequest().setRecordId(domainRecord.recordId).setRR(domainRecord.RR).setType(domainRecord.type).setValue(domainRecord.value).setTTL(domainRecord.TTL);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            UpdateDomainRecordResponse updateDomainRecordResponse = client.updateDomainRecordWithOptions(updateDomainRecordRequest, runtime);
        }
        catch (Exception ex) {
            log.error("updateDomeainRecord:" + domainRecord.recordId + "\u3001RR:" + domainRecord.getRR() + " is error. message:" + ex.getMessage(), ex);
        }
    }

    public String delDomeainRecord(DomainRecord domainRecord) throws Exception {
        Client client = this.createClient(domainRecord.getAccesskeyid(), domainRecord.getAccesskeysecret());
        DeleteDomainRecordRequest deleteDomainRecordRequest = new DeleteDomainRecordRequest();
        deleteDomainRecordRequest.setRecordId(domainRecord.recordId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            DeleteDomainRecordResponse response = client.deleteDomainRecordWithOptions(deleteDomainRecordRequest, runtime);
            return response.body.getRecordId();
        }
        catch (Exception ex) {
            log.error(Common.assertAsString(ex.getMessage()), ex);
            return null;
        }
    }

    public String getipv6Prefix() throws SocketException {
        String os = System.getProperty("os.name").toLowerCase();
        log.info(os);
        if (os.indexOf("windows") > -1) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                    Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress addr = addresses.nextElement();
                        if (!(addr instanceof Inet6Address) || addr.getHostAddress().contains("fe80") || !addr.getHostAddress().contains("0:0:0")) continue;
                        String ipv6 = addr.getHostAddress();
                        return ipv6.substring(0, ipv6.indexOf("0:0") + 1);
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        } else {
            ShellUtils shellUtils = new ShellUtils();
            try {
                String ipv6 = shellUtils.executels("ip -6 addr show | grep 'inet6.*global' | head -n1 | awk '{print $2}' | cut -d':' -f1-4 | cut -d'/' -f1 ");
                ipv6 = ipv6.replaceAll("\n", "");
                return ipv6;
            }
            catch (Exception e) {
                log.error("getipv6Addresses is error,msg: " + e.getMessage());
            }
        }
        return null;
    }
}

