/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.test;

import info.gdsy.utils.AliDNSUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class IPv6AddressExample {
    public static void main(String[] args) {
        try {
            List<Object> ipv6Addresses = new ArrayList();
            IPv6AddressExample iPv6AddressExample = new IPv6AddressExample();
            AliDNSUtil aliDNSUtil = new AliDNSUtil();
            String ip = aliDNSUtil.getipv6Prefix();
            ipv6Addresses = iPv6AddressExample.getipv6Addresses("266f:8cff:fe71:dbd4");
            String osName = System.getProperty("os.name").toLowerCase();
            System.out.println(osName);
            if (osName.contains("windows")) {
                for (String string : ipv6Addresses) {
                    System.out.println(string);
                }
            } else if (osName.contains("linux")) {
                for (String string : ipv6Addresses) {
                    System.out.println(string);
                }
            }
            System.out.println("ip2:" + ip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> getipv6Addresses(String ipv6) throws SocketException {
        ArrayList<String> ipv6Addresses = new ArrayList<String>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (!networkInterface.isUp()) continue;
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!(address instanceof Inet6Address) || !address.getHostAddress().contains(ipv6) || !address.getHostAddress().contains("2408:") && !address.getHostAddress().contains("240e:") && !address.getHostAddress().contains("2001:")) continue;
                ipv6Addresses.add(StringUtils.substring(address.getHostAddress(), 0, address.getHostAddress().indexOf(ipv6) + ipv6.length()));
            }
        }
        return ipv6Addresses;
    }
}

