/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.service;

import info.gdsy.bean.bo.DomainRecord;
import info.gdsy.bean.po.GlobalPO;
import info.gdsy.conf.bean.Domain;
import info.gdsy.utils.AliDNSUtil;
import info.gdsy.utils.quartz.TaskCron;
import info.gdsy.utils.quartz.TaskParam;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecTask
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ExecTask.class);
    public static boolean isStop;

    @Override
    public void run() {
        do {
            AliDNSUtil aliDNSUtil = new AliDNSUtil();
            try {
                TaskParam taskParam = TaskCron.task.take();
                Domain md = (Domain)taskParam.getParam()[0];
                Map<String, DomainRecord> domainRecordMap = GlobalPO.domainRecordMap.get(taskParam.getTaskName());
                String s_ipv6 = aliDNSUtil.getipv6Prefix();
                log.info("s_ipv6:" + s_ipv6);
                for (String rr : md.getDomainMap().keySet()) {
                    log.info("*******************************check server:" + rr + "*********************************");
                    Domain cd = md.getDomainMap().get(rr);
                    DomainRecord cdr = domainRecordMap.get(rr);
                    aliDNSUtil.getDomainRecord(cdr);
                    log.info(rr + "." + cdr.getDomainName() + "online addr:" + cdr.value + ",Current IPv6 prefix:" + s_ipv6);
                    String ipAddress = s_ipv6 + ":" + cd.getIpv6();
                    if (cdr.value.indexOf(s_ipv6) < 0) {
                        cdr.setValue(ipAddress);
                        aliDNSUtil.updateDomeainRecord(cdr);
                        log.info("[" + cdr.getRR() + "." + taskParam.getTaskName() + "]\u3001ip address  update ,ip address:" + ipAddress);
                        continue;
                    }
                    log.info(rr + "." + cdr.getDomainName() + " ip address:" + ipAddress + "\u3001\u65e0\u66f4\u65b0...");
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), ex);
            }
        } while (!isStop);
        this.exit();
    }

    private void exit() {
        log.info("\u51c6\u5907\u505c\u6b62JMX");
        try {
            log.info("JMX\u505c\u6b62\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        log.info("\u7a0b\u5e8f\u5173\u95ed\uff01");
        System.exit(0);
    }
}

