/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.dao;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import info.gdsy.utils.ConfigUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariDBConnection {
    private static final Logger log = LoggerFactory.getLogger(HikariDBConnection.class);
    private static HikariDBConnection instance = null;
    private boolean isJavaDB = false;
    private static Map<String, DataSource> dsMap = new HashMap<String, DataSource>();

    public static HikariDBConnection getInstance() throws Exception {
        if (instance == null) {
            instance = new HikariDBConnection();
        }
        return instance;
    }

    public Connection getConnection(String propertiesName) {
        try {
            if (dsMap.containsKey(propertiesName)) {
                return dsMap.get(propertiesName).getConnection();
            }
            Properties properties = this.readProperties(propertiesName);
            HikariConfig config = new HikariConfig(properties);
            HikariDataSource dataSource = new HikariDataSource(config);
            dsMap.put(propertiesName, dataSource);
            return dataSource.getConnection();
        }
        catch (Exception ex) {
            log.error("error:" + ex.getMessage(), ex);
            return null;
        }
    }

    public Connection setConnection(String propertiesName, HikariConfig config) {
        try {
            HikariDataSource dataSource = new HikariDataSource(config);
            dsMap.put(propertiesName, dataSource);
            return dataSource.getConnection();
        }
        catch (Exception ex) {
            log.error("error:" + ex.getMessage(), ex);
            return null;
        }
    }

    private Properties readProperties(String propertiesName) throws Exception {
        Properties pro = new Properties();
        try {
            ConfigUtils configUtils = new ConfigUtils();
            pro = configUtils.readProperties(propertiesName);
        }
        catch (Exception ex) {
            log.error(propertiesName + ".properties loader error");
        }
        return pro;
    }
}

