/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.dao;

import com.alibaba.druid.pool.DruidDataSourceFactory;
import info.gdsy.utils.ConfigUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConnection {
    private static final Logger log = LoggerFactory.getLogger(DBConnection.class);
    private static DBConnection instance = null;
    private boolean isJavaDB = false;
    private static Map<String, DataSource> dsMap = new HashMap<String, DataSource>();

    public static DBConnection getInstance() throws Exception {
        if (instance == null) {
            instance = new DBConnection();
        }
        return instance;
    }

    public Connection getConnection(String propertiesName) throws Exception {
        if (dsMap.containsKey(propertiesName)) {
            return dsMap.get(propertiesName).getConnection();
        }
        DataSource ds = DruidDataSourceFactory.createDataSource(this.readProperties(propertiesName));
        dsMap.put(propertiesName, ds);
        ds.getConnection().isClosed();
        return ds.getConnection();
    }

    private Properties readProperties(String propertiesName) throws Exception {
        Properties pro = new Properties();
        try {
            ConfigUtils configUtils = new ConfigUtils();
            pro = configUtils.readProperties(propertiesName);
        }
        catch (Exception ex) {
            log.error(propertiesName + ".properties loader error");
        }
        return pro;
    }
}

