/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy.dao;

import info.gdsy.dao.DBConnection;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.sql.Connection;
import java.util.HashMap;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDao {
    private static final Logger log = LoggerFactory.getLogger(BaseDao.class);
    protected static final org.apache.logging.log4j.Logger sqllog = LogManager.getLogger("sqllog");

    public void insert(String dsName, String sql, Object[][] params) throws Exception {
        if (params == null || StringUtils.isBlank(sql)) {
            throw new Exception("params can't be null and sql can't be empty!");
        }
        Connection conn = null;
        try {
            conn = DBConnection.getInstance().getConnection(dsName);
            QueryRunner queryRunner = new QueryRunner();
            ArrayHandler handler = new ArrayHandler();
            queryRunner.insertBatch(conn, sql, handler, params);
        }
        catch (Exception ex) {
            sqllog.error(ex.getMessage(), (Throwable)ex);
            throw new Exception("insert error, sql is:" + sql, ex);
        }
        finally {
            DbUtils.close(conn);
        }
    }

    public Long insert(String dsName, String sql, Object[] params) throws Exception {
        if (params == null || StringUtils.isBlank(sql)) {
            throw new Exception("params can't be null and sql can't be empty!");
        }
        Connection conn = null;
        Long res = null;
        try {
            conn = DBConnection.getInstance().getConnection(dsName);
            QueryRunner queryRunner = new QueryRunner();
            res = (Long)queryRunner.insert(conn, sql, new ScalarHandler(), params);
            log.info("id:" + res.intValue());
        }
        catch (Exception ex) {
            sqllog.error(ex.getMessage(), (Throwable)ex);
            throw new Exception("insert error, sql is:" + sql, ex);
        }
        finally {
            DbUtils.close(conn);
        }
        return res;
    }

    public Long insertByBean(String dsName, String sql, Object javaBean) throws Exception {
        Object[] obj = this.paseJavaBean(sql, javaBean);
        return this.insert(dsName, sql, obj);
    }

    public int update(String dsName, String sql, Object[] params) throws Exception {
        Connection conn = null;
        QueryRunner queryRunner = new QueryRunner();
        int result = 0;
        try {
            ArrayHandler handler = new ArrayHandler();
            conn = DBConnection.getInstance().getConnection(dsName);
            result = params != null ? queryRunner.update(conn, sql, params) : queryRunner.update(conn, sql);
        }
        catch (Exception ex) {
            try {
                sqllog.error(ex.getMessage(), (Throwable)ex);
                throw new Exception("update error, sql is:" + sql, ex);
            }
            catch (Throwable throwable) {
                DbUtils.close(conn);
                throw throwable;
            }
        }
        DbUtils.close(conn);
        return result;
    }

    public int[] updates(String dsName, String sql, Object[][] params) throws Exception {
        if (params == null || StringUtils.isBlank(sql)) {
            throw new Exception("params can't be null and sql can't be empty!");
        }
        Connection conn = null;
        int[] result = null;
        try {
            conn = DBConnection.getInstance().getConnection(dsName);
            QueryRunner queryRunner = new QueryRunner();
            ArrayHandler handler = new ArrayHandler();
            result = queryRunner.batch(conn, sql, params);
        }
        catch (Exception ex) {
            sqllog.error(ex.getMessage(), (Throwable)ex);
            throw new Exception("batch update error, sql is:" + sql, ex);
        }
        finally {
            DbUtils.close(conn);
        }
        return result;
    }

    public int update(String dsName, String sql) throws Exception {
        Connection conn = null;
        int i = 0;
        try {
            conn = DBConnection.getInstance().getConnection(dsName);
            QueryRunner queryRunner = new QueryRunner();
            ArrayHandler handler = new ArrayHandler();
            i = queryRunner.update(conn, sql);
        }
        catch (Exception ex) {
            sqllog.error(ex.getMessage(), (Throwable)ex);
            throw new Exception("update error, sql is:" + sql, ex);
        }
        finally {
            DbUtils.close(conn);
        }
        return i;
    }

    public static void main(String[] args) throws Exception {
        BaseDao baseDao = new BaseDao();
        String sql = "insert into users(AppKey,AppSecret,token,expires_in,begintime,endtime,ipaddress,isvalid) value(?,?,?,?,?,?,?,?)";
    }

    public Object[] paseJavaBean(String sql, Object javabean) throws Exception {
        PropertyDescriptor[] propertyDescriptor;
        String infield = StringUtils.substringBetween(sql, "(", ")");
        String[] fields = infield.split(",");
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(javabean.getClass());
        for (PropertyDescriptor p : propertyDescriptor = beanInfo.getPropertyDescriptors()) {
            map.put(p.getName().toUpperCase(), p.getReadMethod().invoke(javabean, new Object[0]));
        }
        Object[] objc = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            objc[i] = map.get(fields[i].toUpperCase().trim());
        }
        return objc;
    }
}

