/*
 * Decompiled with CFR 0.152.
 */
package info.gdsy;

import com.aliyun.alidns20150109.Client;
import com.aliyun.alidns20150109.models.DescribeDomainRecordsRequest;
import com.aliyun.alidns20150109.models.DescribeDomainRecordsResponse;
import com.aliyun.alidns20150109.models.DescribeDomainRecordsResponseBody;
import com.aliyun.teautil.models.RuntimeOptions;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import info.gdsy.bean.bo.DomainRecord;
import info.gdsy.bean.po.GlobalPO;
import info.gdsy.conf.SystemConfig;
import info.gdsy.conf.bean.Domain;
import info.gdsy.service.ExecTask;
import info.gdsy.utils.AliDNSUtil;
import info.gdsy.utils.ConfigUtils;
import info.gdsy.utils.quartz.TaskCron;
import info.gdsy.utils.quartz.TaskParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSStart
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DNSStart.class);

    public static void main(String[] args_) throws Exception {
        try {
            DNSStart start = new DNSStart();
            Thread t = new Thread(start);
            log.info("DNS  start...");
            t.start();
            t.join();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    @Override
    public void run() {
        try {
            this.readconfig("SystemConfig.xml");
            this.loadTask();
            this.getDomainRecordls();
            this.addDomainRecordls();
            ExecTask execTask = new ExecTask();
            ExecTask.isStop = false;
            execTask.start();
        }
        catch (Exception ex) {
            ExecTask.isStop = true;
            log.error(ex.getMessage(), ex);
        }
    }

    public DNSStart() {
        Runtime.getRuntime().addShutdownHook(new ExitHandler());
    }

    private void loadTask() {
        TaskCron taskCron = new TaskCron();
        List<Domain> domains = SystemConfig.getInstance().getDomains().getDomain();
        for (Domain domain : domains) {
            TaskParam taskParam = new TaskParam();
            taskParam.setTaskName(domain.getName());
            taskParam.setCron(domain.getCron());
            taskParam.setParam(domain);
            TaskCron.taskCronMap.put(domain.getName(), taskParam);
            log.info(domain.getName() + " start succeeded!");
        }
        taskCron.start();
    }

    private void readconfig(String systemconfig) {
        try {
            Document document = null;
            document = new ConfigUtils().readconfig(systemconfig);
            XStream xstream = new XStream(new DomDriver());
            xstream.autodetectAnnotations(true);
            xstream.processAnnotations(SystemConfig.class);
            xstream.allowTypes(new Class[]{SystemConfig.class});
            SystemConfig.setInstance((SystemConfig)xstream.fromXML(document.asXML()));
            this.convertCdomaintoMap();
            log.info("alidns tools SystemConfig Loading succeeded!");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
        }
    }

    private void convertCdomaintoMap() {
        List<Domain> domains = SystemConfig.getInstance().getDomains().getDomain();
        for (Domain domain : domains) {
            HashMap<String, Domain> domainMap = new HashMap<String, Domain>();
            domain.setDomainMap(domainMap);
            List<Domain> cdomains = domain.getCdomains().getDomain();
            for (Domain cdom : cdomains) {
                domain.put(cdom.getRr(), cdom);
            }
            domain.getCdomains().getDomain().clear();
        }
    }

    private void addDomainRecordls() throws Exception {
        List<Domain> domains = SystemConfig.getInstance().getDomains().getDomain();
        AliDNSUtil aliDNSUtil = new AliDNSUtil();
        for (Domain domain : domains) {
            Map<String, DomainRecord> cdr = GlobalPO.domainRecordMap.get(domain.getName());
            Map<String, Domain> cdmap = domain.getDomainMap();
            String s_ipv6 = aliDNSUtil.getipv6Prefix();
            log.info("IPv6 \u524d\u7f00: " + s_ipv6);
            if (s_ipv6 != null) {
                for (String rr : cdmap.keySet()) {
                    Domain cd = cdmap.get(rr);
                    if (cdr.containsKey(rr)) continue;
                    DomainRecord domainRecord = new DomainRecord();
                    domainRecord.setDomainName(domain.getName());
                    domainRecord.setValue(s_ipv6 + ":" + cd.getIpv6());
                    domainRecord.setTTL(cd.getTtl());
                    domainRecord.setRR(rr);
                    domainRecord.setType("AAAA");
                    domainRecord.setAccesskeyid(domain.getAccesskeyid());
                    domainRecord.setAccesskeysecret(domain.getAccesskeysecret());
                    String recordId = aliDNSUtil.addDomainRecord(domainRecord);
                    domainRecord.setRecordId(recordId);
                    cdr.put(rr, domainRecord);
                    log.info(domain.getName() + "\u3001recordId:" + recordId + "\u3001RR:" + rr + " register success!");
                }
                continue;
            }
            log.error("addDomainRecordls Failure : Invalid IP address");
        }
    }

    private void getDomainRecordls() throws Exception {
        List<Domain> domains = SystemConfig.getInstance().getDomains().getDomain();
        for (Domain domain : domains) {
            Client client = new AliDNSUtil().createClient(domain.getAccesskeyid(), domain.getAccesskeysecret());
            DescribeDomainRecordsRequest describeDomainRecordsRequest = new DescribeDomainRecordsRequest().setPageSize(500L).setType("AAAA").setDomainName(domain.getName());
            RuntimeOptions runtime = new RuntimeOptions();
            try {
                Map<Object, Object> domainRecordMap;
                DescribeDomainRecordsResponse response = client.describeDomainRecordsWithOptions(describeDomainRecordsRequest, runtime);
                List<DescribeDomainRecordsResponseBody.DescribeDomainRecordsResponseBodyDomainRecordsRecord> record = response.body.domainRecords.record;
                if (!GlobalPO.domainRecordMap.containsKey(domain.getName())) {
                    domainRecordMap = new HashMap();
                    GlobalPO.domainRecordMap.put(domain.getName(), domainRecordMap);
                } else {
                    domainRecordMap = GlobalPO.domainRecordMap.get(domain.getName());
                }
                Map<String, Domain> cd = domain.getDomainMap();
                for (DescribeDomainRecordsResponseBody.DescribeDomainRecordsResponseBodyDomainRecordsRecord de : record) {
                    log.info("getDomainRecordls - de.getRR:" + de.getRR());
                    if (domainRecordMap.containsKey(de.getRR()) || !cd.containsKey(de.getRR())) continue;
                    DomainRecord dr = this.getDomainRecord(domain, de);
                    domainRecordMap.put(de.getRR(), dr);
                    log.info(dr.getDomainName() + "\u3001recordId:" + dr.getRecordId() + "\u3001RR:" + dr.getRR() + " reset Recordls success!");
                }
                log.info("getDomainRecordls finished: " + domainRecordMap.size() + " records   ");
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), ex);
            }
        }
    }

    private DomainRecord getDomainRecord(Domain domain, DescribeDomainRecordsResponseBody.DescribeDomainRecordsResponseBodyDomainRecordsRecord de) {
        DomainRecord domainRecord = new DomainRecord();
        domainRecord.setAccesskeyid(domain.getAccesskeyid());
        domainRecord.setAccesskeysecret(domain.getAccesskeysecret());
        domainRecord.setDomainName(domain.getName());
        domainRecord.setRecordId(de.getRecordId());
        domainRecord.setLine(de.getLine());
        domainRecord.setRecordId(de.getRecordId());
        domainRecord.setStatus(de.getStatus());
        domainRecord.setRR(de.RR);
        domainRecord.setTTL(de.TTL);
        domainRecord.setLocked(de.locked);
        domainRecord.setType(de.type);
        domainRecord.setValue(de.value);
        domainRecord.setRemark(de.remark);
        domainRecord.setPriority(de.priority);
        domainRecord.setWeight(de.weight);
        return domainRecord;
    }

    private static class ExitHandler
    extends Thread {
        public ExitHandler() {
            super("Exit Handler");
        }

        @Override
        public void run() {
            log.info("alarm shutdown...");
            ExecTask.isStop = true;
        }
    }
}

