/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.DbType;
import com.alibaba.druid.VERSION;
import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxy;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.ResultSetMetaDataProxy;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.ServletPathMatcher;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.druid.util.Utils;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallCheckResult;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallContext;
import com.alibaba.druid.wall.WallFilterMBean;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallSQLException;
import com.alibaba.druid.wall.WallSqlStat;
import com.alibaba.druid.wall.WallUpdateCheckItem;
import com.alibaba.druid.wall.spi.ClickhouseWallProvider;
import com.alibaba.druid.wall.spi.DB2WallProvider;
import com.alibaba.druid.wall.spi.MySqlWallProvider;
import com.alibaba.druid.wall.spi.OracleWallProvider;
import com.alibaba.druid.wall.spi.PGWallProvider;
import com.alibaba.druid.wall.spi.SQLServerWallProvider;
import com.alibaba.druid.wall.spi.SQLiteWallProvider;
import com.alibaba.druid.wall.violation.SyntaxErrorViolation;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class WallFilter
extends FilterAdapter
implements WallFilterMBean {
    private static final Log LOG = LogFactory.getLog(WallFilter.class);
    private boolean inited = false;
    private WallProvider provider;
    private String dbTypeName;
    private WallConfig config;
    private volatile boolean logViolation = false;
    private volatile boolean throwException = true;
    public static final String ATTR_SQL_STAT = "wall.sqlStat";
    public static final String ATTR_UPDATE_CHECK_ITEMS = "wall.updateCheckItems";
    private static final ThreadLocal<List<Integer>> tenantColumnsLocal = new ThreadLocal();

    public WallFilter() {
        this.configFromProperties(System.getProperties());
    }

    @Override
    public void configFromProperties(Properties properties) {
        Boolean value = Utils.getBoolean(properties, "druid.wall.logViolation");
        if (value != null) {
            this.logViolation = value;
        }
        if ((value = Utils.getBoolean(properties, "druid.wall.throwException")) != null) {
            this.throwException = value;
        }
        if (this.config != null) {
            this.config.configFromProperties(properties);
        }
    }

    @Override
    public synchronized void init(DataSourceProxy dataSource) {
        if (dataSource == null) {
            LOG.error("dataSource should not be null");
            return;
        }
        if (this.dbTypeName == null || this.dbTypeName.trim().length() == 0) {
            this.dbTypeName = dataSource.getDbType() != null ? dataSource.getDbType() : JdbcUtils.getDbType(dataSource.getRawJdbcUrl(), "");
        }
        if (this.dbTypeName == null) {
            this.dbTypeName = JdbcUtils.getDbType(dataSource.getUrl(), null);
        }
        DbType dbType = DbType.of(this.dbTypeName);
        switch (dbType) {
            case mysql: 
            case oceanbase: 
            case drds: 
            case mariadb: 
            case h2: 
            case presto: 
            case trino: {
                if (this.config == null) {
                    this.config = new WallConfig("META-INF/druid/wall/mysql");
                }
                this.provider = new MySqlWallProvider(this.config);
                break;
            }
            case oracle: 
            case ali_oracle: 
            case oceanbase_oracle: {
                if (this.config == null) {
                    this.config = new WallConfig("META-INF/druid/wall/oracle");
                }
                this.provider = new OracleWallProvider(this.config);
                break;
            }
            case sqlserver: 
            case jtds: {
                if (this.config == null) {
                    this.config = new WallConfig("META-INF/druid/wall/sqlserver");
                }
                this.provider = new SQLServerWallProvider(this.config);
                break;
            }
            case postgresql: 
            case edb: 
            case polardb: 
            case greenplum: 
            case gaussdb: {
                if (this.config == null) {
                    this.config = new WallConfig("META-INF/druid/wall/postgres");
                }
                this.provider = new PGWallProvider(this.config);
                break;
            }
            case db2: {
                if (this.config == null) {
                    this.config = new WallConfig("META-INF/druid/wall/db2");
                }
                this.provider = new DB2WallProvider(this.config);
                break;
            }
            case sqlite: {
                if (this.config == null) {
                    this.config = new WallConfig("META-INF/druid/wall/sqlite");
                }
                this.provider = new SQLiteWallProvider(this.config);
                break;
            }
            case clickhouse: {
                if (this.config == null) {
                    this.config = new WallConfig("META-INF/druid/wall/clickhouse");
                }
                this.provider = new ClickhouseWallProvider(this.config);
                break;
            }
            default: {
                throw new IllegalStateException("dbType not support : " + (Object)((Object)dbType) + ", url " + dataSource.getUrl());
            }
        }
        this.provider.setName(dataSource.getName());
        this.inited = true;
    }

    @Override
    public String getDbType() {
        return this.dbTypeName;
    }

    public void setDbType(String dbType) {
        this.dbTypeName = dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbTypeName = dbType == null ? null : dbType.name();
    }

    @Override
    public boolean isLogViolation() {
        return this.logViolation;
    }

    @Override
    public void setLogViolation(boolean logViolation) {
        this.logViolation = logViolation;
    }

    @Override
    public boolean isThrowException() {
        return this.throwException;
    }

    @Override
    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    @Override
    public void clearProviderCache() {
        if (this.provider != null) {
            this.provider.clearCache();
        }
    }

    @Override
    public Set<String> getProviderWhiteList() {
        if (this.provider == null) {
            return Collections.emptySet();
        }
        return this.provider.getWhiteList();
    }

    public WallProvider getProvider() {
        return this.provider;
    }

    public WallConfig getConfig() {
        return this.config;
    }

    public void setConfig(WallConfig config) {
        this.config = config;
    }

    public void setTenantColumn(String tenantColumn) {
        this.config.setTenantColumn(tenantColumn);
    }

    public String getTenantColumn() {
        return this.config.getTenantColumn();
    }

    @Override
    public boolean isInited() {
        return this.inited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statement_addBatch(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            chain.statement_addBatch(statement, sql);
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public void preparedStatement_addBatch(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        chain.preparedStatement_addBatch(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext context = WallContext.create(dbType);
        try {
            WallCheckResult result = this.checkInternal(sql);
            context.setWallUpdateCheckItems(result.getUpdateCheckItems());
            sql = result.getSql();
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int autoGeneratedKeys) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext context = WallContext.create(dbType);
        try {
            WallCheckResult result = this.checkInternal(sql);
            context.setWallUpdateCheckItems(result.getUpdateCheckItems());
            sql = result.getSql();
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql, autoGeneratedKeys);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext context = WallContext.create(dbType);
        try {
            WallCheckResult result = this.checkInternal(sql);
            context.setWallUpdateCheckItems(result.getUpdateCheckItems());
            sql = result.getSql();
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext context = WallContext.create(dbType);
        try {
            WallCheckResult result = this.checkInternal(sql);
            context.setWallUpdateCheckItems(result.getUpdateCheckItems());
            sql = result.getSql();
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int[] columnIndexes) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext context = WallContext.create(dbType);
        try {
            WallCheckResult result = this.checkInternal(sql);
            context.setWallUpdateCheckItems(result.getUpdateCheckItems());
            sql = result.getSql();
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql, columnIndexes);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, String[] columnNames) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext context = WallContext.create(dbType);
        try {
            WallCheckResult result = this.checkInternal(sql);
            context.setWallUpdateCheckItems(result.getUpdateCheckItems());
            sql = result.getSql();
            PreparedStatementProxy stmt = chain.connection_prepareStatement(connection, sql, columnNames);
            this.setSqlStatAttribute(stmt);
            PreparedStatementProxy preparedStatementProxy = stmt;
            return preparedStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext context = WallContext.create(dbType);
        try {
            WallCheckResult result = this.checkInternal(sql);
            context.setWallUpdateCheckItems(result.getUpdateCheckItems());
            sql = result.getSql();
            CallableStatementProxy stmt = chain.connection_prepareCall(connection, sql);
            this.setSqlStatAttribute(stmt);
            CallableStatementProxy callableStatementProxy = stmt;
            return callableStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext context = WallContext.create(dbType);
        try {
            WallCheckResult result = this.checkInternal(sql);
            context.setWallUpdateCheckItems(result.getUpdateCheckItems());
            sql = result.getSql();
            CallableStatementProxy stmt = chain.connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
            this.setSqlStatAttribute(stmt);
            CallableStatementProxy callableStatementProxy = stmt;
            return callableStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String dbType = connection.getDirectDataSource().getDbType();
        WallContext context = WallContext.create(dbType);
        try {
            WallCheckResult result = this.checkInternal(sql);
            context.setWallUpdateCheckItems(result.getUpdateCheckItems());
            sql = result.getSql();
            CallableStatementProxy stmt = chain.connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.setSqlStatAttribute(stmt);
            CallableStatementProxy callableStatementProxy = stmt;
            return callableStatementProxy;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        WallContext originalContext = WallContext.current();
        try {
            this.createWallContext(statement);
            sql = this.check(sql);
            boolean firstResult = chain.statement_execute(statement, sql);
            if (!firstResult) {
                int updateCount = statement.getUpdateCount();
                this.statExecuteUpdate(updateCount);
            } else {
                this.setSqlStatAttribute(statement);
            }
            boolean bl = firstResult;
            return bl;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            if (originalContext != null) {
                WallContext.setContext(originalContext);
            }
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            boolean firstResult = chain.statement_execute(statement, sql, autoGeneratedKeys);
            if (!firstResult) {
                int updateCount = statement.getUpdateCount();
                this.statExecuteUpdate(updateCount);
            } else {
                this.setSqlStatAttribute(statement);
            }
            boolean bl = firstResult;
            return bl;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            boolean firstResult = chain.statement_execute(statement, sql, columnIndexes);
            if (!firstResult) {
                int updateCount = statement.getUpdateCount();
                this.statExecuteUpdate(updateCount);
            } else {
                this.setSqlStatAttribute(statement);
            }
            boolean bl = firstResult;
            return bl;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            boolean firstResult = chain.statement_execute(statement, sql, columnNames);
            if (!firstResult) {
                int updateCount = statement.getUpdateCount();
                this.statExecuteUpdate(updateCount);
            } else {
                this.setSqlStatAttribute(statement);
            }
            boolean bl = firstResult;
            return bl;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public int[] statement_executeBatch(FilterChain chain, StatementProxy statement) throws SQLException {
        WallSqlStat sqlStat = (WallSqlStat)statement.getAttribute(ATTR_SQL_STAT);
        try {
            int[] updateCounts = chain.statement_executeBatch(statement);
            int updateCount = 0;
            for (int count : updateCounts) {
                updateCount += count;
            }
            if (sqlStat != null) {
                this.provider.addUpdateCount(sqlStat, updateCount);
            }
            int[] nArray = updateCounts;
            return nArray;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public ResultSetProxy statement_executeQuery(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            ResultSetProxy resultSetProxy = chain.statement_executeQuery(statement, sql);
            this.preprocessResultSet(resultSetProxy);
            ResultSetProxy resultSetProxy2 = resultSetProxy;
            return resultSetProxy2;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            int updateCount = chain.statement_executeUpdate(statement, sql);
            this.statExecuteUpdate(updateCount);
            int n = updateCount;
            return n;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            int updateCount = chain.statement_executeUpdate(statement, sql, autoGeneratedKeys);
            this.statExecuteUpdate(updateCount);
            int n = updateCount;
            return n;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            int updateCount = chain.statement_executeUpdate(statement, sql, columnIndexes);
            this.statExecuteUpdate(updateCount);
            int n = updateCount;
            return n;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    public String getDbType(StatementProxy statement) {
        return statement.getConnectionProxy().getDirectDataSource().getDbType();
    }

    private WallContext createWallContext(StatementProxy statement) {
        String dbType = this.getDbType(statement);
        return WallContext.create(dbType);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        this.createWallContext(statement);
        try {
            sql = this.check(sql);
            int updateCount = chain.statement_executeUpdate(statement, sql, columnNames);
            this.statExecuteUpdate(updateCount);
            int n = updateCount;
            return n;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount();
            throw ex;
        }
        finally {
            WallContext.clearContext();
        }
    }

    @Override
    public boolean preparedStatement_execute(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        try {
            this.wallUpdateCheck(statement);
            boolean firstResult = chain.preparedStatement_execute(statement);
            if (!firstResult) {
                WallSqlStat sqlStat = (WallSqlStat)statement.getAttribute(ATTR_SQL_STAT);
                int updateCount = statement.getUpdateCount();
                if (sqlStat != null) {
                    this.provider.addUpdateCount(sqlStat, updateCount);
                }
            }
            return firstResult;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount(statement);
            throw ex;
        }
    }

    @Override
    public ResultSetProxy preparedStatement_executeQuery(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        try {
            ResultSetProxy resultSetProxy = chain.preparedStatement_executeQuery(statement);
            this.preprocessResultSet(resultSetProxy);
            return resultSetProxy;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount(statement);
            throw ex;
        }
    }

    @Override
    public int preparedStatement_executeUpdate(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        try {
            this.wallUpdateCheck(statement);
            int updateCount = chain.preparedStatement_executeUpdate(statement);
            WallSqlStat sqlStat = (WallSqlStat)statement.getAttribute(ATTR_SQL_STAT);
            if (sqlStat != null) {
                this.provider.addUpdateCount(sqlStat, updateCount);
            }
            return updateCount;
        }
        catch (SQLException ex) {
            this.incrementExecuteErrorCount(statement);
            throw ex;
        }
    }

    private void wallUpdateCheck(PreparedStatementProxy statement) throws SQLException {
        Map<Integer, JdbcParameter> parameterMap = statement.getParameters();
        List wallUpdateCheckItems = (List)statement.getAttribute(ATTR_UPDATE_CHECK_ITEMS);
        if (wallUpdateCheckItems != null) {
            for (WallUpdateCheckItem item : wallUpdateCheckItems) {
                int index;
                Object parameter;
                Object setValue = item.value instanceof SQLValuableExpr ? ((SQLValuableExpr)item.value).getValue() : ((parameter = parameterMap.get(index = ((SQLVariantRefExpr)item.value).getIndex())) != null ? parameter.getValue() : null);
                ArrayList<Object> filtersValues = new ArrayList<Object>(item.filterValues.size());
                parameter = item.filterValues.iterator();
                while (parameter.hasNext()) {
                    int index2;
                    JdbcParameter parameter2;
                    SQLExpr filterValueExpr = (SQLExpr)parameter.next();
                    Object filterValue = filterValueExpr instanceof SQLValuableExpr ? ((SQLValuableExpr)filterValueExpr).getValue() : ((parameter2 = parameterMap.get(index2 = ((SQLVariantRefExpr)filterValueExpr).getIndex())) != null ? parameter2.getValue() : null);
                    filtersValues.add(filterValue);
                }
                boolean valid = this.config.updateCheckHandler.check(item.tableName, item.columnName, setValue, filtersValues);
                if (valid) continue;
                throw new SQLException("wall update check failed.");
            }
        }
    }

    @Override
    public ResultSetProxy statement_getResultSet(FilterChain chain, StatementProxy statement) throws SQLException {
        ResultSetProxy resultSetProxy = chain.statement_getResultSet(statement);
        this.preprocessResultSet(resultSetProxy);
        return resultSetProxy;
    }

    @Override
    public ResultSetProxy statement_getGeneratedKeys(FilterChain chain, StatementProxy statement) throws SQLException {
        ResultSetProxy resultSetProxy = chain.statement_getGeneratedKeys(statement);
        this.preprocessResultSet(resultSetProxy);
        return resultSetProxy;
    }

    public void setSqlStatAttribute(StatementProxy stmt) {
        WallContext context = WallContext.current();
        if (context == null) {
            return;
        }
        WallSqlStat sqlStat = context.getSqlStat();
        if (sqlStat == null) {
            return;
        }
        stmt.putAttribute(ATTR_SQL_STAT, sqlStat);
        List<WallUpdateCheckItem> wallUpdateCheckItems = context.getWallUpdateCheckItems();
        if (wallUpdateCheckItems != null) {
            stmt.putAttribute(ATTR_UPDATE_CHECK_ITEMS, wallUpdateCheckItems);
        }
    }

    public void statExecuteUpdate(int updateCount) {
        WallContext context = WallContext.current();
        if (context == null) {
            return;
        }
        WallSqlStat sqlStat = context.getSqlStat();
        if (sqlStat == null) {
            return;
        }
        if (updateCount > 0) {
            this.provider.addUpdateCount(sqlStat, updateCount);
        }
    }

    public void incrementExecuteErrorCount(PreparedStatementProxy statement) {
        WallSqlStat sqlStat = (WallSqlStat)statement.getAttribute(ATTR_SQL_STAT);
        if (sqlStat != null) {
            sqlStat.incrementAndGetExecuteErrorCount();
        }
    }

    public void incrementExecuteErrorCount() {
        WallContext context = WallContext.current();
        if (context == null) {
            return;
        }
        WallSqlStat sqlStat = context.getSqlStat();
        if (sqlStat == null) {
            return;
        }
        sqlStat.incrementAndGetExecuteErrorCount();
    }

    @Override
    public String check(String sql) throws SQLException {
        return this.checkInternal(sql).getSql();
    }

    private WallCheckResult checkInternal(String sql) throws SQLException {
        WallCheckResult checkResult = this.provider.check(sql);
        List<Violation> violations = checkResult.getViolations();
        if (violations.size() > 0) {
            Violation firstViolation = violations.get(0);
            if (this.isLogViolation()) {
                LOG.error("sql injection violation, dbType " + this.getDbType() + ", druid-version " + VERSION.getVersionNumber() + ", " + firstViolation.getMessage() + " : " + sql);
            }
            if (this.throwException) {
                if (violations.get(0) instanceof SyntaxErrorViolation) {
                    SyntaxErrorViolation violation = (SyntaxErrorViolation)violations.get(0);
                    throw new SQLException("sql injection violation, dbType " + this.getDbType() + ", , druid-version " + VERSION.getVersionNumber() + ", " + firstViolation.getMessage() + " : " + sql, violation.getException());
                }
                throw new SQLException("sql injection violation, dbType " + this.getDbType() + ", druid-version " + VERSION.getVersionNumber() + ", " + firstViolation.getMessage() + " : " + sql);
            }
        }
        return checkResult;
    }

    @Override
    public boolean isWrapperFor(FilterChain chain, Wrapper wrapper, Class<?> iface) throws SQLException {
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPrivileged()) {
            return chain.isWrapperFor(wrapper, iface);
        }
        return this.provider.getConfig().isWrapAllow() && chain.isWrapperFor(wrapper, iface);
    }

    @Override
    public <T> T unwrap(FilterChain chain, Wrapper wrapper, Class<T> iface) throws SQLException {
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPrivileged()) {
            return chain.unwrap(wrapper, iface);
        }
        if (!this.provider.getConfig().isWrapAllow()) {
            return null;
        }
        return chain.unwrap(wrapper, iface);
    }

    @Override
    public DatabaseMetaData connection_getMetaData(FilterChain chain, ConnectionProxy connection) throws SQLException {
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPrivileged()) {
            return chain.connection_getMetaData(connection);
        }
        if (!this.provider.getConfig().isMetadataAllow()) {
            if (this.isLogViolation()) {
                LOG.error("not support method : Connection.getMetaData");
            }
            if (this.throwException) {
                throw new WallSQLException("not support method : Connection.getMetaData");
            }
        }
        return chain.connection_getMetaData(connection);
    }

    @Override
    public void resultSet_close(FilterChain chain, ResultSetProxy resultSet) throws SQLException {
        chain.resultSet_close(resultSet);
        int fetchRowCount = resultSet.getFetchRowCount();
        WallSqlStat sqlStat = (WallSqlStat)resultSet.getStatementProxy().getAttribute(ATTR_SQL_STAT);
        if (sqlStat == null) {
            return;
        }
        this.provider.addFetchRowCount(sqlStat, fetchRowCount);
    }

    @Override
    public int resultSet_findColumn(FilterChain chain, ResultSetProxy resultSet, String columnLabel) throws SQLException {
        int physicalColumn = chain.resultSet_findColumn(resultSet, columnLabel);
        return resultSet.getLogicColumn(physicalColumn);
    }

    @Override
    public Array resultSet_getArray(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getArray(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public InputStream resultSet_getAsciiStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getAsciiStream(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public BigDecimal resultSet_getBigDecimal(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getBigDecimal(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public BigDecimal resultSet_getBigDecimal(FilterChain chain, ResultSetProxy resultSet, int columnIndex, int scale) throws SQLException {
        return chain.resultSet_getBigDecimal(resultSet, resultSet.getPhysicalColumn(columnIndex), scale);
    }

    @Override
    public InputStream resultSet_getBinaryStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getBinaryStream(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public Blob resultSet_getBlob(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getBlob(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public boolean resultSet_getBoolean(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getBoolean(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public byte resultSet_getByte(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getByte(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public byte[] resultSet_getBytes(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getBytes(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public Reader resultSet_getCharacterStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getCharacterStream(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public Clob resultSet_getClob(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getClob(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public Date resultSet_getDate(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getDate(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public Date resultSet_getDate(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Calendar cal) throws SQLException {
        return chain.resultSet_getDate(resultSet, resultSet.getPhysicalColumn(columnIndex), cal);
    }

    @Override
    public double resultSet_getDouble(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getDouble(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public float resultSet_getFloat(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getFloat(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public int resultSet_getInt(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getInt(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public long resultSet_getLong(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getLong(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public Reader resultSet_getNCharacterStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getNCharacterStream(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public NClob resultSet_getNClob(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getNClob(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public String resultSet_getNString(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getNString(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public Object resultSet_getObject(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getObject(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public <T> T resultSet_getObject(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Class<T> type) throws SQLException {
        return chain.resultSet_getObject(resultSet, resultSet.getPhysicalColumn(columnIndex), type);
    }

    @Override
    public Object resultSet_getObject(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return chain.resultSet_getObject(resultSet, resultSet.getPhysicalColumn(columnIndex), map);
    }

    @Override
    public Ref resultSet_getRef(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getRef(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public RowId resultSet_getRowId(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getRowId(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public SQLXML resultSet_getSQLXML(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getSQLXML(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public short resultSet_getShort(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getShort(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public String resultSet_getString(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getString(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public Time resultSet_getTime(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getTime(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public Time resultSet_getTime(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Calendar cal) throws SQLException {
        return chain.resultSet_getTime(resultSet, resultSet.getPhysicalColumn(columnIndex), cal);
    }

    @Override
    public Timestamp resultSet_getTimestamp(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getTimestamp(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public Timestamp resultSet_getTimestamp(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Calendar cal) throws SQLException {
        return chain.resultSet_getTimestamp(resultSet, resultSet.getPhysicalColumn(columnIndex), cal);
    }

    @Override
    public URL resultSet_getURL(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getURL(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public InputStream resultSet_getUnicodeStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        return chain.resultSet_getUnicodeStream(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public void resultSet_updateArray(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Array x) throws SQLException {
        chain.resultSet_updateArray(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateAsciiStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, InputStream x) throws SQLException {
        chain.resultSet_updateAsciiStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateAsciiStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, InputStream x, int length) throws SQLException {
        chain.resultSet_updateAsciiStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x, length);
    }

    @Override
    public void resultSet_updateAsciiStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, InputStream x, long length) throws SQLException {
        chain.resultSet_updateAsciiStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x, length);
    }

    @Override
    public void resultSet_updateBigDecimal(FilterChain chain, ResultSetProxy resultSet, int columnIndex, BigDecimal x) throws SQLException {
        chain.resultSet_updateBigDecimal(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateBinaryStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, InputStream x) throws SQLException {
        chain.resultSet_updateBinaryStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateBinaryStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, InputStream x, int length) throws SQLException {
        chain.resultSet_updateBinaryStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x, length);
    }

    @Override
    public void resultSet_updateBinaryStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, InputStream x, long length) throws SQLException {
        chain.resultSet_updateBinaryStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x, length);
    }

    @Override
    public void resultSet_updateBlob(FilterChain chain, ResultSetProxy resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        chain.resultSet_updateBlob(resultSet, resultSet.getPhysicalColumn(columnIndex), inputStream);
    }

    @Override
    public void resultSet_updateBlob(FilterChain chain, ResultSetProxy resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        chain.resultSet_updateBlob(resultSet, resultSet.getPhysicalColumn(columnIndex), inputStream, length);
    }

    @Override
    public void resultSet_updateBlob(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Blob x) throws SQLException {
        chain.resultSet_updateBlob(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateBoolean(FilterChain chain, ResultSetProxy resultSet, int columnIndex, boolean x) throws SQLException {
        chain.resultSet_updateBoolean(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateByte(FilterChain chain, ResultSetProxy resultSet, int columnIndex, byte x) throws SQLException {
        chain.resultSet_updateByte(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateBytes(FilterChain chain, ResultSetProxy resultSet, int columnIndex, byte[] x) throws SQLException {
        chain.resultSet_updateBytes(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateCharacterStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Reader x) throws SQLException {
        chain.resultSet_updateCharacterStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateCharacterStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Reader x, int length) throws SQLException {
        chain.resultSet_updateCharacterStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x, length);
    }

    @Override
    public void resultSet_updateCharacterStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Reader x, long length) throws SQLException {
        chain.resultSet_updateCharacterStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x, length);
    }

    @Override
    public void resultSet_updateClob(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Clob x) throws SQLException {
        chain.resultSet_updateClob(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateClob(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Reader reader) throws SQLException {
        chain.resultSet_updateClob(resultSet, resultSet.getPhysicalColumn(columnIndex), reader);
    }

    @Override
    public void resultSet_updateClob(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        chain.resultSet_updateClob(resultSet, resultSet.getPhysicalColumn(columnIndex), reader, length);
    }

    @Override
    public void resultSet_updateDate(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Date x) throws SQLException {
        chain.resultSet_updateDate(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateDouble(FilterChain chain, ResultSetProxy resultSet, int columnIndex, double x) throws SQLException {
        chain.resultSet_updateDouble(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateFloat(FilterChain chain, ResultSetProxy resultSet, int columnIndex, float x) throws SQLException {
        chain.resultSet_updateFloat(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateInt(FilterChain chain, ResultSetProxy resultSet, int columnIndex, int x) throws SQLException {
        chain.resultSet_updateInt(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateLong(FilterChain chain, ResultSetProxy resultSet, int columnIndex, long x) throws SQLException {
        chain.resultSet_updateLong(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateNCharacterStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Reader x) throws SQLException {
        chain.resultSet_updateNCharacterStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateNCharacterStream(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Reader x, long length) throws SQLException {
        chain.resultSet_updateNCharacterStream(resultSet, resultSet.getPhysicalColumn(columnIndex), x, length);
    }

    @Override
    public void resultSet_updateNClob(FilterChain chain, ResultSetProxy resultSet, int columnIndex, NClob nClob) throws SQLException {
        chain.resultSet_updateNClob(resultSet, resultSet.getPhysicalColumn(columnIndex), nClob);
    }

    @Override
    public void resultSet_updateNClob(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Reader reader) throws SQLException {
        chain.resultSet_updateNClob(resultSet, resultSet.getPhysicalColumn(columnIndex), reader);
    }

    @Override
    public void resultSet_updateNClob(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        chain.resultSet_updateNClob(resultSet, resultSet.getPhysicalColumn(columnIndex), reader, length);
    }

    @Override
    public void resultSet_updateNString(FilterChain chain, ResultSetProxy resultSet, int columnIndex, String nString) throws SQLException {
        chain.resultSet_updateNString(resultSet, resultSet.getPhysicalColumn(columnIndex), nString);
    }

    @Override
    public void resultSet_updateNull(FilterChain chain, ResultSetProxy resultSet, int columnIndex) throws SQLException {
        chain.resultSet_updateNull(resultSet, resultSet.getPhysicalColumn(columnIndex));
    }

    @Override
    public void resultSet_updateObject(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Object x) throws SQLException {
        chain.resultSet_updateObject(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateObject(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Object x, int scaleOrLength) throws SQLException {
        chain.resultSet_updateObject(resultSet, resultSet.getPhysicalColumn(columnIndex), x, scaleOrLength);
    }

    @Override
    public void resultSet_updateRef(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Ref x) throws SQLException {
        chain.resultSet_updateRef(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateRowId(FilterChain chain, ResultSetProxy resultSet, int columnIndex, RowId x) throws SQLException {
        chain.resultSet_updateRowId(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateShort(FilterChain chain, ResultSetProxy resultSet, int columnIndex, short x) throws SQLException {
        chain.resultSet_updateShort(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateSQLXML(FilterChain chain, ResultSetProxy resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        chain.resultSet_updateSQLXML(resultSet, resultSet.getPhysicalColumn(columnIndex), xmlObject);
    }

    @Override
    public void resultSet_updateString(FilterChain chain, ResultSetProxy resultSet, int columnIndex, String x) throws SQLException {
        chain.resultSet_updateString(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateTime(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Time x) throws SQLException {
        chain.resultSet_updateTime(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public void resultSet_updateTimestamp(FilterChain chain, ResultSetProxy resultSet, int columnIndex, Timestamp x) throws SQLException {
        chain.resultSet_updateTimestamp(resultSet, resultSet.getPhysicalColumn(columnIndex), x);
    }

    @Override
    public boolean resultSet_next(FilterChain chain, ResultSetProxy resultSet) throws SQLException {
        List<Integer> tenantColumns;
        boolean hasNext = chain.resultSet_next(resultSet);
        WallConfig.TenantCallBack callback = this.provider.getConfig().getTenantCallBack();
        if (callback != null && hasNext && (tenantColumns = tenantColumnsLocal.get()) != null && tenantColumns.size() > 0) {
            for (Integer columnIndex : tenantColumns) {
                Object value = resultSet.getResultSetRaw().getObject(columnIndex);
                callback.filterResultsetTenantColumn(value);
            }
        }
        return hasNext;
    }

    @Override
    public int resultSetMetaData_getColumnCount(FilterChain chain, ResultSetMetaDataProxy metaData) throws SQLException {
        int count = chain.resultSetMetaData_getColumnCount(metaData);
        return count - metaData.getResultSetProxy().getHiddenColumnCount();
    }

    @Override
    public boolean resultSetMetaData_isAutoIncrement(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_isAutoIncrement(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public boolean resultSetMetaData_isCaseSensitive(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_isCaseSensitive(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public boolean resultSetMetaData_isSearchable(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_isSearchable(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public boolean resultSetMetaData_isCurrency(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_isCurrency(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public int resultSetMetaData_isNullable(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_isNullable(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public boolean resultSetMetaData_isSigned(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_isSigned(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public int resultSetMetaData_getColumnDisplaySize(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getColumnDisplaySize(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public String resultSetMetaData_getColumnLabel(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getColumnLabel(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public String resultSetMetaData_getColumnName(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getColumnName(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public String resultSetMetaData_getSchemaName(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getSchemaName(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public int resultSetMetaData_getPrecision(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getPrecision(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public int resultSetMetaData_getScale(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getScale(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public String resultSetMetaData_getTableName(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getTableName(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public String resultSetMetaData_getCatalogName(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getCatalogName(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public int resultSetMetaData_getColumnType(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getColumnType(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public String resultSetMetaData_getColumnTypeName(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getColumnTypeName(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public boolean resultSetMetaData_isReadOnly(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_isReadOnly(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public boolean resultSetMetaData_isWritable(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_isWritable(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public boolean resultSetMetaData_isDefinitelyWritable(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_isDefinitelyWritable(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public String resultSetMetaData_getColumnClassName(FilterChain chain, ResultSetMetaDataProxy metaData, int column) throws SQLException {
        return chain.resultSetMetaData_getColumnClassName(metaData, metaData.getResultSetProxy().getPhysicalColumn(column));
    }

    @Override
    public long getViolationCount() {
        return this.provider.getViolationCount();
    }

    @Override
    public void resetViolationCount() {
        this.provider.reset();
    }

    @Override
    public void clearWhiteList() {
        this.provider.clearCache();
    }

    @Override
    public boolean checkValid(String sql) {
        return this.provider.checkValid(sql);
    }

    private void preprocessResultSet(ResultSetProxy resultSet) throws SQLException {
        if (resultSet == null) {
            return;
        }
        ResultSetMetaData metaData = resultSet.getResultSetRaw().getMetaData();
        if (metaData == null) {
            return;
        }
        WallConfig.TenantCallBack tenantCallBack = this.provider.getConfig().getTenantCallBack();
        String tenantTablePattern = this.provider.getConfig().getTenantTablePattern();
        if (tenantCallBack == null && (tenantTablePattern == null || tenantTablePattern.length() == 0)) {
            return;
        }
        HashMap<Integer, Integer> logicColumnMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> physicalColumnMap = new HashMap<Integer, Integer>();
        ArrayList<Integer> hiddenColumns = new ArrayList<Integer>();
        ArrayList<Integer> tenantColumns = new ArrayList<Integer>();
        int logicColumn = 1;
        for (int physicalColumn = 1; physicalColumn <= metaData.getColumnCount(); ++physicalColumn) {
            boolean isHidden = false;
            String tableName = metaData.getTableName(physicalColumn);
            String hiddenColumn = null;
            String tenantColumn = null;
            if (tenantCallBack != null) {
                tenantColumn = tenantCallBack.getTenantColumn(WallConfig.TenantCallBack.StatementType.SELECT, tableName);
                hiddenColumn = tenantCallBack.getHiddenColumn(tableName);
            }
            if ((StringUtils.isEmpty(hiddenColumn) || StringUtils.isEmpty(tenantColumn)) && (tableName == null || ServletPathMatcher.getInstance().matches(tenantTablePattern, tableName))) {
                if (StringUtils.isEmpty(hiddenColumn)) {
                    hiddenColumn = this.provider.getConfig().getTenantColumn();
                }
                if (StringUtils.isEmpty(tenantColumn)) {
                    tenantColumn = this.provider.getConfig().getTenantColumn();
                }
            }
            if (!StringUtils.isEmpty(hiddenColumn)) {
                String columnName = metaData.getColumnName(physicalColumn);
                if (null != hiddenColumn && hiddenColumn.equalsIgnoreCase(columnName)) {
                    hiddenColumns.add(physicalColumn);
                    isHidden = true;
                }
            }
            if (!isHidden) {
                logicColumnMap.put(logicColumn, physicalColumn);
                physicalColumnMap.put(physicalColumn, logicColumn);
                ++logicColumn;
            }
            if (StringUtils.isEmpty(tenantColumn) || null == tenantColumn || !tenantColumn.equalsIgnoreCase(metaData.getColumnName(physicalColumn))) continue;
            tenantColumns.add(physicalColumn);
        }
        if (hiddenColumns.size() > 0) {
            resultSet.setLogicColumnMap(logicColumnMap);
            resultSet.setPhysicalColumnMap(physicalColumnMap);
            resultSet.setHiddenColumns(hiddenColumns);
        }
        tenantColumnsLocal.set(tenantColumns);
    }
}

