/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.HexBin;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.sql.XAConnection;

public class MySqlUtils {
    static Class<?> utilClass;
    static boolean utilClassError;
    static boolean utilClass_isJdbc4;
    static Class<?> class_5_connection;
    static Method method_5_getPinGlobalTxToPhysicalConnection;
    static Class<?> class_5_suspendableXAConnection;
    static Constructor<?> constructor_5_suspendableXAConnection;
    static Class<?> class_5_JDBC4SuspendableXAConnection;
    static Constructor<?> constructor_5_JDBC4SuspendableXAConnection;
    static Class<?> class_5_MysqlXAConnection;
    static Constructor<?> constructor_5_MysqlXAConnection;
    static Class<?> class_ConnectionImpl;
    static Method method_getId;
    static boolean method_getId_error;
    static Class<?> class_6_ConnectionImpl;
    static Method method_6_getId;
    static volatile Class<?> class_6_connection;
    static volatile Method method_6_getPropertySet;
    static volatile Method method_6_getBooleanReadableProperty;
    static volatile Method method_6_getValue;
    static volatile boolean method_6_getValue_error;
    static volatile Class<?> class_6_suspendableXAConnection;
    static volatile Method method_6_getInstance;
    static volatile boolean method_6_getInstance_error;
    static volatile Method method_6_getInstanceXA;
    static volatile boolean method_6_getInstanceXA_error;
    static volatile Class<?> class_6_JDBC4SuspendableXAConnection;
    private static Set<String> keywords;
    private static Set<String> builtinDataTypes;
    private static transient Class class_connectionImpl;
    private static transient boolean class_connectionImpl_Error;
    private static transient Method method_getIO;
    private static transient boolean method_getIO_error;
    private static transient Class class_MysqlIO;
    private static transient boolean class_MysqlIO_Error;
    private static transient Method method_getLastPacketReceivedTimeMs;
    private static transient boolean method_getLastPacketReceivedTimeMs_error;
    private static volatile boolean mysqlJdbcVersion6;
    private static transient Class classJdbc;
    private static transient Method getIdleFor;
    private static transient boolean getIdleForError;
    static Class<?> class_5_CommunicationsException;
    static Class<?> class_6_CommunicationsException;
    public static final Charset GBK;
    public static final Charset BIG5;
    public static final Charset UTF8;
    public static final Charset UTF16;
    public static final Charset UTF32;
    public static final Charset ASCII;
    private static BigInteger[] MAX_INT;
    private static BigInteger[] MIN_INT;
    private static BigDecimal[] MAX_DEC_1;
    private static BigDecimal[] MIN_DEC_1;
    private static BigDecimal[] MAX_DEC_2;
    private static BigDecimal[] MIN_DEC_2;
    private static final String[] parseFormats;
    private static final long[] parseFormatCodes;

    public static XAConnection createXAConnection(Driver driver, Connection physicalConn) throws SQLException {
        int major = driver.getMajorVersion();
        if (major == 5) {
            if (utilClass == null && !utilClassError) {
                try {
                    utilClass = Class.forName("com.mysql.jdbc.Util");
                    Method method = utilClass.getMethod("isJdbc4", new Class[0]);
                    utilClass_isJdbc4 = (Boolean)method.invoke(null, new Object[0]);
                    class_5_connection = Class.forName("com.mysql.jdbc.Connection");
                    method_5_getPinGlobalTxToPhysicalConnection = class_5_connection.getMethod("getPinGlobalTxToPhysicalConnection", new Class[0]);
                    class_5_suspendableXAConnection = Class.forName("com.mysql.jdbc.jdbc2.optional.SuspendableXAConnection");
                    constructor_5_suspendableXAConnection = class_5_suspendableXAConnection.getConstructor(class_5_connection);
                    class_5_JDBC4SuspendableXAConnection = Class.forName("com.mysql.jdbc.jdbc2.optional.JDBC4SuspendableXAConnection");
                    constructor_5_JDBC4SuspendableXAConnection = class_5_JDBC4SuspendableXAConnection.getConstructor(class_5_connection);
                    class_5_MysqlXAConnection = Class.forName("com.mysql.jdbc.jdbc2.optional.MysqlXAConnection");
                    constructor_5_MysqlXAConnection = class_5_MysqlXAConnection.getConstructor(class_5_connection, Boolean.TYPE);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    utilClassError = true;
                }
            }
            try {
                boolean pinGlobTx = (Boolean)method_5_getPinGlobalTxToPhysicalConnection.invoke((Object)physicalConn, new Object[0]);
                if (pinGlobTx) {
                    if (!utilClass_isJdbc4) {
                        return (XAConnection)constructor_5_suspendableXAConnection.newInstance(physicalConn);
                    }
                    return (XAConnection)constructor_5_JDBC4SuspendableXAConnection.newInstance(physicalConn);
                }
                return (XAConnection)constructor_5_MysqlXAConnection.newInstance(physicalConn, Boolean.FALSE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (major == 6 || major == 8) {
            block30: {
                if (method_6_getValue == null && !method_6_getValue_error) {
                    try {
                        class_6_connection = Class.forName("com.mysql.cj.api.jdbc.JdbcConnection");
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        if (class_6_connection == null) {
                            class_6_connection = Class.forName("com.mysql.cj.jdbc.JdbcConnection");
                            method_6_getPropertySet = class_6_connection.getMethod("getPropertySet", new Class[0]);
                            Class<?> propertySetClass = Class.forName("com.mysql.cj.conf.PropertySet");
                            NoSuchMethodException noSuchMethodException = null;
                            try {
                                method_6_getBooleanReadableProperty = propertySetClass.getMethod("getBooleanReadableProperty", String.class);
                                method_6_getValue = Class.forName("com.mysql.cj.conf.ReadableProperty").getMethod("getValue", new Class[0]);
                            }
                            catch (NoSuchMethodException error) {
                                noSuchMethodException = error;
                            }
                            if (method_6_getBooleanReadableProperty == null) {
                                method_6_getBooleanReadableProperty = propertySetClass.getMethod("getBooleanProperty", String.class);
                                method_6_getValue = Class.forName("com.mysql.cj.conf.RuntimeProperty").getMethod("getValue", new Class[0]);
                            }
                            break block30;
                        }
                        method_6_getPropertySet = class_6_connection.getMethod("getPropertySet", new Class[0]);
                        method_6_getBooleanReadableProperty = Class.forName("com.mysql.cj.api.conf.PropertySet").getMethod("getBooleanReadableProperty", String.class);
                        method_6_getValue = Class.forName("com.mysql.cj.api.conf.ReadableProperty").getMethod("getValue", new Class[0]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        method_6_getValue_error = true;
                    }
                }
            }
            try {
                Boolean pinGlobTx = (Boolean)method_6_getValue.invoke(method_6_getBooleanReadableProperty.invoke(method_6_getPropertySet.invoke((Object)physicalConn, new Object[0]), "pinGlobalTxToPhysicalConnection"), new Object[0]);
                if (pinGlobTx != null && pinGlobTx.booleanValue()) {
                    try {
                        if (method_6_getInstance == null && !method_6_getInstance_error) {
                            class_6_suspendableXAConnection = Class.forName("com.mysql.cj.jdbc.SuspendableXAConnection");
                            method_6_getInstance = class_6_suspendableXAConnection.getDeclaredMethod("getInstance", class_6_connection);
                            method_6_getInstance.setAccessible(true);
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        method_6_getInstance_error = true;
                    }
                    return (XAConnection)method_6_getInstance.invoke(null, physicalConn);
                }
                try {
                    if (method_6_getInstanceXA == null && !method_6_getInstanceXA_error) {
                        class_6_JDBC4SuspendableXAConnection = Class.forName("com.mysql.cj.jdbc.MysqlXAConnection");
                        method_6_getInstanceXA = class_6_JDBC4SuspendableXAConnection.getDeclaredMethod("getInstance", class_6_connection, Boolean.TYPE);
                        method_6_getInstanceXA.setAccessible(true);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    method_6_getInstanceXA_error = true;
                }
                return (XAConnection)method_6_getInstanceXA.invoke(null, physicalConn, Boolean.FALSE);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                method_6_getInstance_error = true;
            }
        }
        throw new SQLFeatureNotSupportedException();
    }

    public static String buildKillQuerySql(Connection connection, SQLException error) throws SQLException {
        Long threadId = MySqlUtils.getId(connection);
        if (threadId == null) {
            return null;
        }
        return "KILL QUERY " + threadId;
    }

    public static boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        String name_lower = name.toLowerCase();
        Set<String> words = keywords;
        if (words == null) {
            words = new HashSet<String>();
            Utils.loadFromFile("META-INF/druid/parser/mysql/keywords", words);
            keywords = words;
        }
        return words.contains(name_lower);
    }

    public static boolean isBuiltinDataType(String dataType) {
        if (dataType == null) {
            return false;
        }
        String table_lower = dataType.toLowerCase();
        Set<String> dataTypes = builtinDataTypes;
        if (dataTypes == null) {
            dataTypes = new HashSet<String>();
            Utils.loadFromFile("META-INF/druid/parser/mysql/builtin_datatypes", dataTypes);
            builtinDataTypes = dataTypes;
        }
        return dataTypes.contains(table_lower);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> showTables(Connection conn) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("show tables");
            while (rs.next()) {
                String tableName = rs.getString(1);
                tables.add(tableName);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getTableDDL(Connection conn, List<String> tables) throws SQLException {
        ArrayList<String> ddlList = new ArrayList<String>();
        Statement stmt = null;
        try {
            for (String table : tables) {
                ResultSet rs;
                block8: {
                    if (stmt == null) {
                        stmt = conn.createStatement();
                    }
                    if (MySqlUtils.isKeyword(table)) {
                        table = "`" + table + "`";
                    }
                    rs = null;
                    try {
                        rs = stmt.executeQuery("show create table " + table);
                        if (!rs.next()) break block8;
                        String ddl = rs.getString(2);
                        ddlList.add(ddl);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.close(rs);
                        throw throwable;
                        return ddlList;
                    }
                }
                JdbcUtils.close(rs);
            }
        }
        finally {
            JdbcUtils.close(stmt);
        }
    }

    public static String getCreateTableScript(Connection conn) throws SQLException {
        return MySqlUtils.getCreateTableScript(conn, true, true);
    }

    public static String getCreateTableScript(Connection conn, boolean sorted, boolean simplify) throws SQLException {
        List<String> tables = MySqlUtils.showTables(conn);
        List<String> ddlList = MySqlUtils.getTableDDL(conn, tables);
        StringBuilder buf = new StringBuilder();
        for (String ddl : ddlList) {
            buf.append(ddl);
            buf.append(';');
        }
        String ddlScript = buf.toString();
        if (!sorted && !simplify) {
            return ddlScript;
        }
        List<SQLStatement> stmtList = SQLUtils.parseStatements(ddlScript, DbType.mysql);
        if (simplify) {
            for (SQLStatement o : stmtList) {
                if (!(o instanceof SQLCreateTableStatement)) continue;
                SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)o;
                createTableStmt.simplify();
            }
        }
        if (sorted) {
            SQLCreateTableStatement.sort(stmtList);
        }
        return SQLUtils.toSQLString(stmtList, DbType.mysql);
    }

    public static Long getId(Object conn) {
        if (conn == null) {
            return null;
        }
        Class<?> clazz = conn.getClass();
        if (class_ConnectionImpl == null) {
            if (clazz.getName().equals("com.mysql.jdbc.ConnectionImpl")) {
                class_ConnectionImpl = clazz;
            } else if (clazz.getName().equals("com.mysql.jdbc.Connection")) {
                class_ConnectionImpl = clazz;
            } else if (clazz.getName().equals("com.mysql.cj.jdbc.ConnectionImpl")) {
                class_ConnectionImpl = clazz;
            } else if (clazz.getSuperclass().getName().equals("com.mysql.jdbc.ConnectionImpl")) {
                class_ConnectionImpl = clazz.getSuperclass();
            }
        }
        if (class_ConnectionImpl == clazz || class_ConnectionImpl == clazz.getSuperclass()) {
            try {
                if (method_getId == null && !method_getId_error) {
                    Method method = class_ConnectionImpl.getDeclaredMethod("getId", new Class[0]);
                    method.setAccessible(true);
                    method_getId = method;
                }
                return (Long)method_getId.invoke(conn, new Object[0]);
            }
            catch (Throwable ex) {
                method_getId_error = true;
            }
        }
        return null;
    }

    public static long getLastPacketReceivedTimeMs(Connection conn) throws SQLException {
        if (class_connectionImpl == null && !class_connectionImpl_Error) {
            try {
                class_connectionImpl = Utils.loadClass("com.mysql.jdbc.MySQLConnection");
                if (class_connectionImpl == null && (class_connectionImpl = Utils.loadClass("com.mysql.cj.MysqlConnection")) != null) {
                    mysqlJdbcVersion6 = true;
                }
            }
            catch (Throwable error) {
                class_connectionImpl_Error = true;
            }
        }
        if (class_connectionImpl == null) {
            return -1L;
        }
        if (mysqlJdbcVersion6) {
            if (classJdbc == null) {
                classJdbc = Utils.loadClass("com.mysql.cj.jdbc.JdbcConnection");
            }
            if (classJdbc == null) {
                return -1L;
            }
            if (getIdleFor == null && !getIdleForError) {
                try {
                    getIdleFor = classJdbc.getMethod("getIdleFor", new Class[0]);
                    getIdleFor.setAccessible(true);
                }
                catch (Throwable error) {
                    getIdleForError = true;
                }
            }
            if (getIdleFor == null) {
                return -1L;
            }
            try {
                Object connImpl = conn.unwrap(class_connectionImpl);
                if (connImpl == null) {
                    return -1L;
                }
                return System.currentTimeMillis() - (Long)getIdleFor.invoke(connImpl, new Object[0]);
            }
            catch (Exception e) {
                throw new SQLException("getIdleFor error", e);
            }
        }
        if (method_getIO == null && !method_getIO_error) {
            try {
                method_getIO = class_connectionImpl.getMethod("getIO", new Class[0]);
            }
            catch (Throwable error) {
                method_getIO_error = true;
            }
        }
        if (method_getIO == null) {
            return -1L;
        }
        if (class_MysqlIO == null && !class_MysqlIO_Error) {
            try {
                class_MysqlIO = Utils.loadClass("com.mysql.jdbc.MysqlIO");
            }
            catch (Throwable error) {
                class_MysqlIO_Error = true;
            }
        }
        if (class_MysqlIO == null) {
            return -1L;
        }
        if (method_getLastPacketReceivedTimeMs == null && !method_getLastPacketReceivedTimeMs_error) {
            try {
                Method method = class_MysqlIO.getDeclaredMethod("getLastPacketReceivedTimeMs", new Class[0]);
                method.setAccessible(true);
                method_getLastPacketReceivedTimeMs = method;
            }
            catch (Throwable error) {
                method_getLastPacketReceivedTimeMs_error = true;
            }
        }
        if (method_getLastPacketReceivedTimeMs == null) {
            return -1L;
        }
        try {
            Object connImpl = conn.unwrap(class_connectionImpl);
            if (connImpl == null) {
                return -1L;
            }
            Object mysqlio = method_getIO.invoke(connImpl, new Object[0]);
            return (Long)method_getLastPacketReceivedTimeMs.invoke(mysqlio, new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException("getLastPacketReceivedTimeMs error", e);
        }
    }

    public static Class getCommunicationsExceptionClass() {
        if (class_5_CommunicationsException != null) {
            return class_5_CommunicationsException;
        }
        if (class_6_CommunicationsException != null) {
            return class_6_CommunicationsException;
        }
        class_5_CommunicationsException = Utils.loadClass("com.mysql.jdbc.CommunicationsException");
        if (class_5_CommunicationsException != null) {
            return class_5_CommunicationsException;
        }
        class_6_CommunicationsException = Utils.loadClass("com.mysql.cj.jdbc.exceptions.CommunicationsException");
        if (class_6_CommunicationsException != null) {
            return class_6_CommunicationsException;
        }
        return null;
    }

    public static void loadDataTypes(Set<String> dataTypes) {
        Utils.loadFromFile("META-INF/druid/parser/mysql/builtin_datatypes", dataTypes);
    }

    public static BigDecimal decimal(BigDecimal value, int precision, int scale) {
        int v_precision;
        int v_scale = value.scale();
        if (v_scale > scale) {
            value = value.setScale(scale, 4);
            v_precision = value.precision();
        } else {
            v_precision = value.precision();
        }
        int v_ints = v_precision - v_scale;
        int ints = precision - scale;
        if (v_precision > precision || v_ints > ints) {
            boolean sign;
            boolean bl = sign = value.signum() > 0;
            if (scale == 1) {
                return sign ? MAX_DEC_1[ints] : MIN_DEC_1[ints];
            }
            if (scale == 2) {
                return sign ? MAX_DEC_2[ints] : MIN_DEC_2[ints];
            }
            return new BigDecimal(sign ? MAX_INT[precision - 1] : MIN_INT[precision - 1], scale);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNumber(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        char c0 = str.charAt(0);
        boolean dot = false;
        boolean expr = false;
        int i = 0;
        if (c0 == '+' || c0 == '-') {
            ++i;
        }
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == '.') {
                if (dot || expr) {
                    return false;
                }
                dot = true;
            } else if (ch == 'e' || ch == 'E') {
                if (expr) {
                    return false;
                }
                expr = true;
                if (i >= str.length() - 1) return false;
                char next = str.charAt(i + 1);
                if (next == '+' || next == '-') {
                    ++i;
                }
            } else if (ch < '0' || ch > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static DateFormat toJavaFormat(String fmt, TimeZone timeZone) {
        DateFormat dateFormat = MySqlUtils.toJavaFormat(fmt);
        if (dateFormat == null) {
            return null;
        }
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    public static DateFormat toJavaFormat(String fmt) {
        if (fmt == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int len = fmt.length();
        for (int i = 0; i < len; ++i) {
            char ch = fmt.charAt(i);
            if (ch == '%') {
                if (i + 1 == len) {
                    return null;
                }
                char next_ch = fmt.charAt(++i);
                switch (next_ch) {
                    case 'a': {
                        buf.append("EEE");
                        break;
                    }
                    case 'b': {
                        buf.append("MMM");
                        break;
                    }
                    case 'c': {
                        buf.append("M");
                        break;
                    }
                    case 'd': {
                        buf.append("dd");
                        break;
                    }
                    case 'e': {
                        buf.append("d");
                        break;
                    }
                    case 'f': {
                        buf.append("SSS000");
                        break;
                    }
                    case 'H': 
                    case 'k': {
                        buf.append("HH");
                        break;
                    }
                    case 'I': 
                    case 'h': 
                    case 'l': {
                        buf.append("hh");
                        break;
                    }
                    case 'i': {
                        buf.append("mm");
                        break;
                    }
                    case 'M': {
                        buf.append("MMMMM");
                        break;
                    }
                    case 'm': {
                        buf.append("MM");
                        break;
                    }
                    case 'p': {
                        buf.append('a');
                        break;
                    }
                    case 'r': {
                        buf.append("hh:mm:ss a");
                        break;
                    }
                    case 'S': 
                    case 's': {
                        buf.append("ss");
                        break;
                    }
                    case 'T': {
                        buf.append("HH:mm:ss");
                        break;
                    }
                    case 'W': {
                        buf.append("EEEEE");
                        break;
                    }
                    case 'w': {
                        buf.append("u");
                        break;
                    }
                    case 'Y': {
                        buf.append("yyyy");
                        break;
                    }
                    case 'y': {
                        buf.append("yy");
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                continue;
            }
            buf.append(ch);
        }
        try {
            return new SimpleDateFormat(buf.toString(), Locale.ENGLISH);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static Date parseDate(String str, TimeZone timeZone) {
        int maxDayOfMonth;
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length < 8) {
            return null;
        }
        ZoneId zoneId = timeZone == null ? ZoneId.systemDefault() : timeZone.toZoneId();
        int y0 = str.charAt(0);
        int y1 = str.charAt(1);
        int y2 = str.charAt(2);
        int y3 = str.charAt(3);
        int M0 = 0;
        int M1 = 0;
        int d0 = 0;
        int d1 = 0;
        int h0 = 0;
        int h1 = 0;
        int m0 = 0;
        char m1 = '\u0000';
        int s0 = 0;
        int s1 = 0;
        int S0 = 48;
        int S1 = 48;
        int S2 = 48;
        char c4 = str.charAt(4);
        int c5 = str.charAt(5);
        int c6 = str.charAt(6);
        int c7 = str.charAt(7);
        int nanos = 0;
        switch (length) {
            case 8: {
                if (c4 == '-' && c6 == 45) {
                    M0 = 48;
                    M1 = c5;
                    d0 = 48;
                    d1 = c7;
                    break;
                }
                if (y2 == 58 && c5 == 58) {
                    h0 = y0;
                    h1 = y1;
                    m0 = y3;
                    m1 = c4;
                    s0 = c6;
                    s1 = c7;
                    y0 = 49;
                    y1 = 57;
                    y2 = 55;
                    y3 = 48;
                    M0 = 48;
                    M1 = 49;
                    d0 = 48;
                    d1 = 49;
                    break;
                }
                M0 = c4;
                M1 = c5;
                d0 = c6;
                d1 = c7;
                break;
            }
            case 9: {
                int c8 = str.charAt(8);
                if (c4 != '-') {
                    return null;
                }
                if (c6 == 45) {
                    M0 = 48;
                    M1 = c5;
                    d0 = c7;
                    d1 = c8;
                    break;
                }
                if (c7 == 45) {
                    M0 = c5;
                    M1 = c6;
                    d0 = 48;
                    d1 = c8;
                    break;
                }
                return null;
            }
            case 10: {
                char c8 = str.charAt(8);
                int c9 = str.charAt(9);
                if (c4 != '-' || c7 != 45) {
                    return null;
                }
                M0 = c5;
                M1 = c6;
                d0 = c8;
                d1 = c9;
                break;
            }
            case 14: {
                char c8 = str.charAt(8);
                char c9 = str.charAt(9);
                char c10 = str.charAt(10);
                char c11 = str.charAt(11);
                char c12 = str.charAt(12);
                char c13 = str.charAt(13);
                if (c8 == ' ') {
                    if (c4 == '-' && c6 == 45 & c10 == ':' && c12 == ':') {
                        M0 = 48;
                        M1 = c5;
                        d0 = 48;
                        d1 = c7;
                        h0 = 48;
                        h1 = c9;
                        m0 = 48;
                        m1 = c11;
                        s0 = 48;
                        s1 = c13;
                        break;
                    }
                    return null;
                }
                M0 = c4;
                M1 = c5;
                d0 = c6;
                d1 = c7;
                h0 = c8;
                h1 = c9;
                m0 = c10;
                m1 = c11;
                s0 = c12;
                s1 = c13;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: {
                int lastOff;
                char n2;
                int offset;
                if (length == 19 || length == 23 || length == 29) {
                    char c8 = str.charAt(8);
                    char c9 = str.charAt(9);
                    char c10 = str.charAt(10);
                    char c11 = str.charAt(11);
                    char c12 = str.charAt(12);
                    char c13 = str.charAt(13);
                    char c14 = str.charAt(14);
                    char c15 = str.charAt(15);
                    char c16 = str.charAt(16);
                    char c17 = str.charAt(17);
                    char c18 = str.charAt(18);
                    if (c4 == '-' && c7 == 45 && (c10 == ' ' || c10 == 'T') && (c13 == ':' && c16 == ':' || c13 == '.' && c16 == '.')) {
                        char c22;
                        char c21;
                        char c20;
                        char c19;
                        M0 = c5;
                        M1 = c6;
                        d0 = c8;
                        d1 = c9;
                        h0 = c11;
                        h1 = c12;
                        m0 = c14;
                        m1 = c15;
                        s0 = c17;
                        s1 = c18;
                        if (length == 23) {
                            c19 = str.charAt(19);
                            c20 = str.charAt(20);
                            c21 = str.charAt(21);
                            c22 = str.charAt(22);
                            if (c19 == '.') {
                                S0 = c20;
                                S1 = c21;
                                S2 = c22;
                                break;
                            }
                            if (c19 == ' ' && c20 == 'U' && c21 == 'T' && c22 == 'C') {
                                zoneId = ZoneOffset.UTC;
                                break;
                            }
                            return null;
                        }
                        if (length != 29) break;
                        c19 = str.charAt(19);
                        c20 = str.charAt(20);
                        c21 = str.charAt(21);
                        c22 = str.charAt(22);
                        if (c19 != '.') {
                            return null;
                        }
                        S0 = c20;
                        S1 = c21;
                        S2 = c22;
                        char c23 = str.charAt(23);
                        char c24 = str.charAt(24);
                        char c25 = str.charAt(25);
                        char c26 = str.charAt(26);
                        char c27 = str.charAt(27);
                        char c28 = str.charAt(28);
                        if (c23 < '0' || c23 > '9' || c24 < '0' || c24 > '9' || c25 < '0' || c25 > '9' || c26 < '0' || c26 > '9' || c27 < '0' || c27 > '9' || c28 < '0' || c28 > '9') {
                            return null;
                        }
                        nanos = (c23 - 48) * 100000 + (c24 - 48) * 10000 + (c25 - 48) * 1000 + (c26 - 48) * 100 + (c27 - 48) * 10 + (c28 - 48);
                        break;
                    }
                }
                if (c4 != '-') {
                    return null;
                }
                if (c6 == 45) {
                    M0 = 48;
                    M1 = c5;
                    offset = 7;
                } else if (c7 == 45) {
                    M0 = c5;
                    M1 = c6;
                    offset = 8;
                } else {
                    return null;
                }
                char n0 = str.charAt(offset);
                char n1 = str.charAt(offset + 1);
                if (n1 == ' ' || n1 == 'T') {
                    d0 = 48;
                    d1 = n0;
                    offset += 2;
                } else {
                    n2 = str.charAt(offset + 2);
                    if (n2 == ' ' || n2 == 'T') {
                        d0 = n0;
                        d1 = n1;
                        offset += 3;
                    } else {
                        return null;
                    }
                }
                n0 = str.charAt(offset);
                n1 = str.charAt(offset + 1);
                if (n1 == ':') {
                    h0 = 48;
                    h1 = n0;
                    offset += 2;
                } else {
                    n2 = str.charAt(offset + 2);
                    if (n2 == ':') {
                        h0 = n0;
                        h1 = n1;
                        offset += 3;
                    } else {
                        return null;
                    }
                }
                n0 = str.charAt(offset);
                n1 = str.charAt(offset + 1);
                if (n1 == ':') {
                    m0 = 48;
                    m1 = n0;
                    offset += 2;
                } else if (offset + 2 < length && (n2 = str.charAt(offset + 2)) == ':') {
                    m0 = n0;
                    m1 = n1;
                    offset += 3;
                } else {
                    return null;
                }
                if (offset == length - 1) {
                    s0 = 48;
                    s1 = str.charAt(offset);
                    break;
                }
                if (offset == length - 2) {
                    n0 = str.charAt(offset);
                    n1 = str.charAt(offset + 1);
                    if (n1 == '.') {
                        s0 = 48;
                        s1 = n0;
                        break;
                    }
                    s0 = n0;
                    s1 = n1;
                    break;
                }
                char x0 = str.charAt(length - 1);
                char x1 = str.charAt(length - 2);
                char x2 = str.charAt(length - 3);
                char x3 = str.charAt(length - 4);
                if (x0 == '.') {
                    lastOff = length - 2;
                } else if (x1 == '.') {
                    S2 = x0;
                    lastOff = length - 3;
                } else if (x2 == '.') {
                    S1 = x1;
                    S2 = x0;
                    lastOff = length - 4;
                } else if (x3 == '.') {
                    S0 = x2;
                    S1 = x1;
                    S2 = x0;
                    lastOff = length - 5;
                } else if ((x2 == '+' || x2 == '-') && length == offset + 5) {
                    String zoneIdStr = new String(new char[]{x2, x1, x0});
                    zoneId = ZoneId.of(zoneIdStr);
                    lastOff = length - 4;
                } else {
                    return null;
                }
                char k0 = str.charAt(lastOff);
                char k1 = str.charAt(lastOff - 1);
                char k2 = str.charAt(lastOff - 2);
                if (k1 == ':') {
                    s0 = 48;
                    s1 = k0;
                    break;
                }
                if (k2 == ':') {
                    s1 = k0;
                    s0 = k1;
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (year < 1970) {
            return null;
        }
        if (M0 < 48 || M0 > 49) {
            return null;
        }
        if (M1 < 48 || M1 > 57) {
            return null;
        }
        int month = (M0 - 48) * 10 + (M1 - 48);
        if (month < 1 || month > 12) {
            return null;
        }
        if (d0 < 48 || d0 > 57) {
            return null;
        }
        if (d1 < 48 || d1 > 57) {
            return null;
        }
        int dayOfMonth = (d0 - 48) * 10 + (d1 - 48);
        if (dayOfMonth < 1) {
            return null;
        }
        switch (month) {
            case 2: {
                maxDayOfMonth = 29;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                maxDayOfMonth = 30;
                break;
            }
            default: {
                maxDayOfMonth = 31;
            }
        }
        if (dayOfMonth > maxDayOfMonth) {
            return null;
        }
        ZonedDateTime zdt = null;
        if (h0 == 0) {
            zdt = LocalDate.of(year, month, dayOfMonth).atStartOfDay(zoneId);
        } else {
            int hour = (h0 - 48) * 10 + (h1 - 48);
            int minute = (m0 - 48) * 10 + (m1 - 48);
            int second = (s0 - 48) * 10 + (s1 - 48);
            int nanoSecond = ((S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48)) * 1000000 + nanos;
            if (hour >= 24 || minute > 60 || second > 61) {
                return null;
            }
            zdt = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoSecond).atZone(zoneId);
        }
        return Date.from(zdt.toInstant());
    }

    public static long parseMillis(byte[] str, TimeZone timeZone) {
        if (str == null) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        return MySqlUtils.parseMillis(str, 0, str.length, timeZone);
    }

    public static long parseMillis(byte[] str, int off, int len, TimeZone timeZone) {
        ZoneId zoneId = timeZone == null ? ZoneId.systemDefault() : timeZone.toZoneId();
        return MySqlUtils.parseDateTime(str, off, len, zoneId).toInstant().toEpochMilli();
    }

    public static ZonedDateTime parseDateTime(byte[] str, int off, int len, ZoneId zoneId) {
        ZonedDateTime zdt;
        int maxDayOfMonth;
        if (str == null) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        if (len < 8) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        int y0 = str[off];
        int y1 = str[off + 1];
        int y2 = str[off + 2];
        int y3 = str[off + 3];
        int M0 = 0;
        int M1 = 0;
        int d0 = 0;
        int d1 = 0;
        int h0 = 0;
        int h1 = 0;
        int m0 = 0;
        int m1 = 0;
        int s0 = 0;
        int s1 = 0;
        int S0 = 48;
        int S1 = 48;
        int S2 = 48;
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int nanos = 0;
        switch (len) {
            case 8: {
                if (c4 == 45 && c6 == 45) {
                    M0 = 48;
                    M1 = c5;
                    d0 = 48;
                    d1 = c7;
                    break;
                }
                if (y2 == 58 && c5 == 58) {
                    h0 = y0;
                    h1 = y1;
                    m0 = y3;
                    m1 = c4;
                    s0 = c6;
                    s1 = c7;
                    y0 = 49;
                    y1 = 57;
                    y2 = 55;
                    y3 = 48;
                    M0 = 48;
                    M1 = 49;
                    d0 = 48;
                    d1 = 49;
                    break;
                }
                M0 = c4;
                M1 = c5;
                d0 = c6;
                d1 = c7;
                break;
            }
            case 9: {
                int c8 = str[off + 8];
                if (c4 != 45) {
                    throw new IllegalArgumentException(new String(str, UTF8));
                }
                if (c6 == 45) {
                    M0 = 48;
                    M1 = c5;
                    d0 = c7;
                    d1 = c8;
                    break;
                }
                if (c7 == 45) {
                    M0 = c5;
                    M1 = c6;
                    d0 = 48;
                    d1 = c8;
                    break;
                }
                throw new IllegalArgumentException(new String(str, UTF8));
            }
            case 10: {
                int c8 = str[off + 8];
                int c9 = str[off + 9];
                if (c4 != 45 || c7 != 45) {
                    throw new IllegalArgumentException(new String(str, UTF8));
                }
                M0 = c5;
                M1 = c6;
                d0 = c8;
                d1 = c9;
                break;
            }
            case 14: {
                int c8 = str[off + 8];
                int c9 = str[off + 9];
                int c10 = str[off + 10];
                int c11 = str[off + 11];
                int c12 = str[off + 12];
                int c13 = str[off + 13];
                if (c8 == 32) {
                    if (c4 == 45 && c6 == 45 & c10 == 58 && c12 == 58) {
                        M0 = 48;
                        M1 = c5;
                        d0 = 48;
                        d1 = c7;
                        h0 = 48;
                        h1 = c9;
                        m0 = 48;
                        m1 = c11;
                        s0 = 48;
                        s1 = c13;
                        break;
                    }
                    throw new IllegalArgumentException(new String(str, UTF8));
                }
                M0 = c4;
                M1 = c5;
                d0 = c6;
                d1 = c7;
                h0 = c8;
                h1 = c9;
                m0 = c10;
                m1 = c11;
                s0 = c12;
                s1 = c13;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                int lastOff;
                byte n2;
                int off2;
                if (len == 19 || len >= 23) {
                    int c8 = str[off + 8];
                    int c9 = str[off + 9];
                    byte c10 = str[off + 10];
                    int c11 = str[off + 11];
                    int c12 = str[off + 12];
                    byte c13 = str[off + 13];
                    int c14 = str[off + 14];
                    int c15 = str[off + 15];
                    byte c16 = str[off + 16];
                    int c17 = str[off + 17];
                    int c18 = str[off + 18];
                    if (c4 == 45 && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 58) {
                        byte c27;
                        byte c26;
                        byte c25;
                        byte c24;
                        byte c23;
                        M0 = c5;
                        M1 = c6;
                        d0 = c8;
                        d1 = c9;
                        h0 = c11;
                        h1 = c12;
                        m0 = c14;
                        m1 = c15;
                        s0 = c17;
                        s1 = c18;
                        if (len == 19) break;
                        byte c19 = str[off + 19];
                        int c20 = str[off + 20];
                        int c21 = str[off + 21];
                        int c22 = str[off + 22];
                        if (len == 23) {
                            if (c19 == 46) {
                                S0 = c20;
                                S1 = c21;
                                S2 = c22;
                                break;
                            }
                            if (c19 == 32 && c20 == 85 && c21 == 84 && c22 == 67) {
                                zoneId = ZoneOffset.UTC;
                                break;
                            }
                            throw new IllegalArgumentException(new String(str, UTF8));
                        }
                        if (c19 != 46) {
                            throw new IllegalArgumentException(new String(str, UTF8));
                        }
                        S0 = c20;
                        S1 = c21;
                        S2 = c22;
                        if (len == 29) {
                            c23 = str[off + 23];
                            c24 = str[off + 24];
                            c25 = str[off + 25];
                            c26 = str[off + 26];
                            c27 = str[off + 27];
                            byte c28 = str[off + 28];
                            if (c23 < 48 || c23 > 57 || c24 < 48 || c24 > 57 || c25 < 48 || c25 > 57 || c26 < 48 || c26 > 57 || c27 < 48 || c27 > 57 || c28 < 48 || c28 > 57) {
                                throw new IllegalArgumentException(new String(str, UTF8));
                            }
                            nanos = (c23 - 48) * 100000 + (c24 - 48) * 10000 + (c25 - 48) * 1000 + (c26 - 48) * 100 + (c27 - 48) * 10 + (c28 - 48);
                            break;
                        }
                        if (len == 28) {
                            c23 = str[off + 23];
                            c24 = str[off + 24];
                            c25 = str[off + 25];
                            c26 = str[off + 26];
                            c27 = str[off + 27];
                            if (c23 < 48 || c23 > 57 || c24 < 48 || c24 > 57 || c25 < 48 || c25 > 57 || c26 < 48 || c26 > 57 || c27 < 48 || c27 > 57) {
                                throw new IllegalArgumentException(new String(str, UTF8));
                            }
                            nanos = (c23 - 48) * 100000 + (c24 - 48) * 10000 + (c25 - 48) * 1000 + (c26 - 48) * 100 + (c27 - 48) * 10;
                            break;
                        }
                        if (len == 27) {
                            c23 = str[off + 23];
                            c24 = str[off + 24];
                            c25 = str[off + 25];
                            c26 = str[off + 26];
                            if (c23 < 48 || c23 > 57 || c24 < 48 || c24 > 57 || c25 < 48 || c25 > 57 || c26 < 48 || c26 > 57) {
                                throw new IllegalArgumentException(new String(str, UTF8));
                            }
                            nanos = (c23 - 48) * 100000 + (c24 - 48) * 10000 + (c25 - 48) * 1000 + (c26 - 48) * 100;
                            break;
                        }
                        if (len != 26) break;
                        c23 = str[off + 23];
                        c24 = str[off + 24];
                        c25 = str[off + 25];
                        if (c23 < 48 || c23 > 57 || c24 < 48 || c24 > 57 || c25 < 48 || c25 > 57) {
                            throw new IllegalArgumentException(new String(str, UTF8));
                        }
                        nanos = (c23 - 48) * 100000 + (c24 - 48) * 10000 + (c25 - 48) * 1000;
                        break;
                    }
                }
                if (c4 != 45) {
                    throw new IllegalArgumentException(new String(str, UTF8));
                }
                if (c6 == 45) {
                    M0 = 48;
                    M1 = c5;
                    off2 = off + 7;
                } else if (c7 == 45) {
                    M0 = c5;
                    M1 = c6;
                    off2 = off + 8;
                } else {
                    throw new IllegalArgumentException(new String(str, UTF8));
                }
                int n0 = str[off2];
                int n1 = str[off2 + 1];
                if (n1 == 32 || n1 == 84) {
                    d0 = 48;
                    d1 = n0;
                    off2 += 2;
                } else {
                    n2 = str[off2 + 2];
                    if (n2 == 32 || n2 == 84) {
                        d0 = n0;
                        d1 = n1;
                        off2 += 3;
                    } else {
                        throw new IllegalArgumentException(new String(str, UTF8));
                    }
                }
                n0 = str[off2];
                n1 = str[off2 + 1];
                if (n1 == 58) {
                    h0 = 48;
                    h1 = n0;
                    off2 += 2;
                } else {
                    n2 = str[off2 + 2];
                    if (n2 == 58) {
                        h0 = n0;
                        h1 = n1;
                        off2 += 3;
                    } else {
                        throw new IllegalArgumentException(new String(str, UTF8));
                    }
                }
                n0 = str[off2];
                n1 = str[off2 + 1];
                if (n1 == 58) {
                    m0 = 48;
                    m1 = n0;
                    off2 += 2;
                } else if (off2 + 2 < off + len && (n2 = str[off2 + 2]) == 58) {
                    m0 = n0;
                    m1 = n1;
                    off2 += 3;
                } else {
                    throw new IllegalArgumentException(new String(str, UTF8));
                }
                if (off2 == off + len - 1) {
                    s0 = 48;
                    s1 = str[off2];
                    break;
                }
                if (off2 == off + len - 2) {
                    n0 = str[off2];
                    n1 = str[off2 + 1];
                    if (n1 == 46) {
                        s0 = 48;
                        s1 = n0;
                        break;
                    }
                    s0 = n0;
                    s1 = n1;
                    break;
                }
                int x0 = str[off + len - 1];
                int x1 = str[off + len - 2];
                int x2 = str[off + len - 3];
                byte x3 = str[off + len - 4];
                if (x0 == 46) {
                    lastOff = off + len - 2;
                } else if (x1 == 46) {
                    S0 = x0;
                    lastOff = off + len - 3;
                } else if (x2 == 46) {
                    S0 = x1;
                    S1 = x0;
                    lastOff = off + len - 4;
                } else if (x3 == 46) {
                    S0 = x2;
                    S1 = x1;
                    S2 = x0;
                    lastOff = off + len - 5;
                } else {
                    throw new IllegalArgumentException(new String(str, UTF8));
                }
                int k0 = str[lastOff];
                int k1 = str[lastOff - 1];
                byte k2 = str[lastOff - 2];
                if (k1 == 58) {
                    s0 = 48;
                    s1 = k0;
                    break;
                }
                if (k2 == 58) {
                    s1 = k0;
                    s0 = k1;
                    break;
                }
                throw new IllegalArgumentException(new String(str, UTF8));
            }
            default: {
                throw new IllegalArgumentException(new String(str, UTF8));
            }
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (M0 < 48 || M0 > 49) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        if (M1 < 48 || M1 > 57) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        int month = (M0 - 48) * 10 + (M1 - 48);
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        if (d0 < 48 || d0 > 57) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        if (d1 < 48 || d1 > 57) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        int dayOfMonth = (d0 - 48) * 10 + (d1 - 48);
        if (dayOfMonth < 1) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        switch (month) {
            case 2: {
                maxDayOfMonth = 29;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                maxDayOfMonth = 30;
                break;
            }
            default: {
                maxDayOfMonth = 31;
            }
        }
        if (dayOfMonth > maxDayOfMonth) {
            throw new IllegalArgumentException(new String(str, UTF8));
        }
        if (h0 == 0) {
            zdt = LocalDate.of(year, month, dayOfMonth).atStartOfDay(zoneId);
        } else {
            int hour = (h0 - 48) * 10 + (h1 - 48);
            int minute = (m0 - 48) * 10 + (m1 - 48);
            int second = (s0 - 48) * 10 + (s1 - 48);
            int nanoSecond = ((S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48)) * 1000000 + nanos;
            if (hour > 24 || minute > 60 || second > 61) {
                throw new IllegalArgumentException(new String(str, UTF8));
            }
            zdt = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoSecond).atZone(zoneId);
        }
        return zdt;
    }

    public static boolean isSupportParseDateformat(String str) {
        if (str == null) {
            return false;
        }
        return Arrays.binarySearch(parseFormatCodes, FnvHash.fnv1a_64(str)) >= 0;
    }

    public static TimeZone parseTimeZone(String str) {
        if ("SYSTEM".equalsIgnoreCase(str)) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(str);
    }

    public static String utf32(String hex) {
        byte[] bytes = HexBin.decode(hex);
        if (bytes.length == 2) {
            return new String(bytes, UTF16);
        }
        return new String(bytes, UTF32);
    }

    public static String utf16(String hex) {
        byte[] bytes;
        if (hex.length() % 2 == 1) {
            char[] chars = new char[hex.length() + 1];
            chars[0] = 48;
            hex.getChars(0, hex.length(), chars, 1);
            hex = new String(chars);
        }
        if ((bytes = HexBin.decode(hex)) == null) {
            return null;
        }
        return new String(bytes, UTF16);
    }

    public static String utf8(String hex) {
        byte[] bytes = HexBin.decode(hex);
        return new String(bytes, UTF8);
    }

    public static String gbk(String hex) {
        byte[] bytes = HexBin.decode(hex);
        return new String(bytes, GBK);
    }

    public static String big5(String hex) {
        byte[] bytes = HexBin.decode(hex);
        return new String(bytes, BIG5);
    }

    static {
        utilClassError = false;
        utilClass_isJdbc4 = false;
        class_5_connection = null;
        method_5_getPinGlobalTxToPhysicalConnection = null;
        class_5_suspendableXAConnection = null;
        constructor_5_suspendableXAConnection = null;
        class_5_JDBC4SuspendableXAConnection = null;
        constructor_5_JDBC4SuspendableXAConnection = null;
        class_5_MysqlXAConnection = null;
        constructor_5_MysqlXAConnection = null;
        class_ConnectionImpl = null;
        method_getId = null;
        method_getId_error = false;
        class_6_ConnectionImpl = null;
        method_6_getId = null;
        class_6_connection = null;
        method_6_getPropertySet = null;
        method_6_getBooleanReadableProperty = null;
        method_6_getValue = null;
        method_6_getValue_error = false;
        class_6_suspendableXAConnection = null;
        method_6_getInstance = null;
        method_6_getInstance_error = false;
        method_6_getInstanceXA = null;
        method_6_getInstanceXA_error = false;
        class_6_JDBC4SuspendableXAConnection = null;
        class_connectionImpl = null;
        class_connectionImpl_Error = false;
        method_getIO = null;
        method_getIO_error = false;
        class_MysqlIO = null;
        class_MysqlIO_Error = false;
        method_getLastPacketReceivedTimeMs = null;
        method_getLastPacketReceivedTimeMs_error = false;
        mysqlJdbcVersion6 = false;
        classJdbc = null;
        getIdleFor = null;
        getIdleForError = false;
        class_5_CommunicationsException = null;
        class_6_CommunicationsException = null;
        GBK = Charset.forName("GBK");
        BIG5 = Charset.forName("BIG5");
        UTF8 = Charset.forName("UTF-8");
        UTF16 = Charset.forName("UTF-16");
        UTF32 = Charset.forName("UTF-32");
        ASCII = Charset.forName("ASCII");
        MAX_INT = new BigInteger[]{new BigInteger("9"), new BigInteger("99"), new BigInteger("999"), new BigInteger("9999"), new BigInteger("99999"), new BigInteger("999999"), new BigInteger("9999999"), new BigInteger("99999999"), new BigInteger("999999999"), new BigInteger("9999999999"), new BigInteger("99999999999"), new BigInteger("999999999999"), new BigInteger("9999999999999"), new BigInteger("99999999999999"), new BigInteger("999999999999999"), new BigInteger("9999999999999999"), new BigInteger("99999999999999999"), new BigInteger("999999999999999999"), new BigInteger("9999999999999999999"), new BigInteger("99999999999999999999"), new BigInteger("999999999999999999999"), new BigInteger("9999999999999999999999"), new BigInteger("99999999999999999999999"), new BigInteger("999999999999999999999999"), new BigInteger("9999999999999999999999999"), new BigInteger("99999999999999999999999999"), new BigInteger("999999999999999999999999999"), new BigInteger("9999999999999999999999999999"), new BigInteger("99999999999999999999999999999"), new BigInteger("999999999999999999999999999999"), new BigInteger("9999999999999999999999999999999"), new BigInteger("99999999999999999999999999999999"), new BigInteger("999999999999999999999999999999999"), new BigInteger("9999999999999999999999999999999999"), new BigInteger("99999999999999999999999999999999999"), new BigInteger("999999999999999999999999999999999999"), new BigInteger("9999999999999999999999999999999999999"), new BigInteger("99999999999999999999999999999999999999")};
        MIN_INT = new BigInteger[]{new BigInteger("-9"), new BigInteger("-99"), new BigInteger("-999"), new BigInteger("-9999"), new BigInteger("-99999"), new BigInteger("-999999"), new BigInteger("-9999999"), new BigInteger("-99999999"), new BigInteger("-999999999"), new BigInteger("-9999999999"), new BigInteger("-99999999999"), new BigInteger("-999999999999"), new BigInteger("-9999999999999"), new BigInteger("-99999999999999"), new BigInteger("-999999999999999"), new BigInteger("-9999999999999999"), new BigInteger("-99999999999999999"), new BigInteger("-999999999999999999"), new BigInteger("-9999999999999999999"), new BigInteger("-99999999999999999999"), new BigInteger("-999999999999999999999"), new BigInteger("-9999999999999999999999"), new BigInteger("-99999999999999999999999"), new BigInteger("-999999999999999999999999"), new BigInteger("-9999999999999999999999999"), new BigInteger("-99999999999999999999999999"), new BigInteger("-999999999999999999999999999"), new BigInteger("-9999999999999999999999999999"), new BigInteger("-99999999999999999999999999999"), new BigInteger("-999999999999999999999999999999"), new BigInteger("-9999999999999999999999999999999"), new BigInteger("-99999999999999999999999999999999"), new BigInteger("-999999999999999999999999999999999"), new BigInteger("-9999999999999999999999999999999999"), new BigInteger("-99999999999999999999999999999999999"), new BigInteger("-999999999999999999999999999999999999"), new BigInteger("-9999999999999999999999999999999999999"), new BigInteger("-99999999999999999999999999999999999999")};
        MAX_DEC_1 = new BigDecimal[]{new BigDecimal("0.9"), new BigDecimal("9.9"), new BigDecimal("99.9"), new BigDecimal("999.9"), new BigDecimal("9999.9"), new BigDecimal("99999.9"), new BigDecimal("999999.9"), new BigDecimal("9999999.9"), new BigDecimal("99999999.9"), new BigDecimal("999999999.9"), new BigDecimal("9999999999.9"), new BigDecimal("99999999999.9"), new BigDecimal("999999999999.9"), new BigDecimal("9999999999999.9"), new BigDecimal("99999999999999.9"), new BigDecimal("999999999999999.9"), new BigDecimal("9999999999999999.9"), new BigDecimal("99999999999999999.9"), new BigDecimal("999999999999999999.9"), new BigDecimal("9999999999999999999.9"), new BigDecimal("99999999999999999999.9"), new BigDecimal("999999999999999999999.9"), new BigDecimal("9999999999999999999999.9"), new BigDecimal("99999999999999999999999.9"), new BigDecimal("999999999999999999999999.9"), new BigDecimal("9999999999999999999999999.9"), new BigDecimal("99999999999999999999999999.9"), new BigDecimal("999999999999999999999999999.9"), new BigDecimal("9999999999999999999999999999.9"), new BigDecimal("99999999999999999999999999999.9"), new BigDecimal("999999999999999999999999999999.9"), new BigDecimal("9999999999999999999999999999999.9"), new BigDecimal("99999999999999999999999999999999.9"), new BigDecimal("999999999999999999999999999999999.9"), new BigDecimal("9999999999999999999999999999999999.9"), new BigDecimal("99999999999999999999999999999999999.9"), new BigDecimal("999999999999999999999999999999999999.9"), new BigDecimal("9999999999999999999999999999999999999.9")};
        MIN_DEC_1 = new BigDecimal[]{new BigDecimal("-0.9"), new BigDecimal("-9.9"), new BigDecimal("-99.9"), new BigDecimal("-999.9"), new BigDecimal("-9999.9"), new BigDecimal("-99999.9"), new BigDecimal("-999999.9"), new BigDecimal("-9999999.9"), new BigDecimal("-99999999.9"), new BigDecimal("-999999999.9"), new BigDecimal("-9999999999.9"), new BigDecimal("-99999999999.9"), new BigDecimal("-999999999999.9"), new BigDecimal("-9999999999999.9"), new BigDecimal("-99999999999999.9"), new BigDecimal("-999999999999999.9"), new BigDecimal("-9999999999999999.9"), new BigDecimal("-99999999999999999.9"), new BigDecimal("-999999999999999999.9"), new BigDecimal("-9999999999999999999.9"), new BigDecimal("-99999999999999999999.9"), new BigDecimal("-999999999999999999999.9"), new BigDecimal("-9999999999999999999999.9"), new BigDecimal("-99999999999999999999999.9"), new BigDecimal("-999999999999999999999999.9"), new BigDecimal("-9999999999999999999999999.9"), new BigDecimal("-99999999999999999999999999.9"), new BigDecimal("-999999999999999999999999999.9"), new BigDecimal("-9999999999999999999999999999.9"), new BigDecimal("-99999999999999999999999999999.9"), new BigDecimal("-999999999999999999999999999999.9"), new BigDecimal("-9999999999999999999999999999999.9"), new BigDecimal("-99999999999999999999999999999999.9"), new BigDecimal("-999999999999999999999999999999999.9"), new BigDecimal("-9999999999999999999999999999999999.9"), new BigDecimal("-99999999999999999999999999999999999.9"), new BigDecimal("-999999999999999999999999999999999999.9"), new BigDecimal("-9999999999999999999999999999999999999.9")};
        MAX_DEC_2 = new BigDecimal[]{new BigDecimal("0.99"), new BigDecimal("9.99"), new BigDecimal("99.99"), new BigDecimal("999.99"), new BigDecimal("9999.99"), new BigDecimal("99999.99"), new BigDecimal("999999.99"), new BigDecimal("9999999.99"), new BigDecimal("99999999.99"), new BigDecimal("999999999.99"), new BigDecimal("9999999999.99"), new BigDecimal("99999999999.99"), new BigDecimal("999999999999.99"), new BigDecimal("9999999999999.99"), new BigDecimal("99999999999999.99"), new BigDecimal("999999999999999.99"), new BigDecimal("9999999999999999.99"), new BigDecimal("99999999999999999.99"), new BigDecimal("999999999999999999.99"), new BigDecimal("9999999999999999999.99"), new BigDecimal("99999999999999999999.99"), new BigDecimal("999999999999999999999.99"), new BigDecimal("9999999999999999999999.99"), new BigDecimal("99999999999999999999999.99"), new BigDecimal("999999999999999999999999.99"), new BigDecimal("9999999999999999999999999.99"), new BigDecimal("99999999999999999999999999.99"), new BigDecimal("999999999999999999999999999.99"), new BigDecimal("9999999999999999999999999999.99"), new BigDecimal("99999999999999999999999999999.99"), new BigDecimal("999999999999999999999999999999.99"), new BigDecimal("9999999999999999999999999999999.99"), new BigDecimal("99999999999999999999999999999999.99"), new BigDecimal("999999999999999999999999999999999.99"), new BigDecimal("9999999999999999999999999999999999.99"), new BigDecimal("99999999999999999999999999999999999.99"), new BigDecimal("999999999999999999999999999999999999.99"), new BigDecimal("9999999999999999999999999999999999999.99")};
        MIN_DEC_2 = new BigDecimal[]{new BigDecimal("-0.99"), new BigDecimal("-9.99"), new BigDecimal("-99.99"), new BigDecimal("-999.99"), new BigDecimal("-9999.99"), new BigDecimal("-99999.99"), new BigDecimal("-999999.99"), new BigDecimal("-9999999.99"), new BigDecimal("-99999999.99"), new BigDecimal("-999999999.99"), new BigDecimal("-9999999999.99"), new BigDecimal("-99999999999.99"), new BigDecimal("-999999999999.99"), new BigDecimal("-9999999999999.99"), new BigDecimal("-99999999999999.99"), new BigDecimal("-999999999999999.99"), new BigDecimal("-9999999999999999.99"), new BigDecimal("-99999999999999999.99"), new BigDecimal("-999999999999999999.99"), new BigDecimal("-9999999999999999999.99"), new BigDecimal("-99999999999999999999.99"), new BigDecimal("-999999999999999999999.99"), new BigDecimal("-9999999999999999999999.99"), new BigDecimal("-99999999999999999999999.99"), new BigDecimal("-999999999999999999999999.99"), new BigDecimal("-9999999999999999999999999.99"), new BigDecimal("-99999999999999999999999999.99"), new BigDecimal("-999999999999999999999999999.99"), new BigDecimal("-9999999999999999999999999999.99"), new BigDecimal("-99999999999999999999999999999.99"), new BigDecimal("-999999999999999999999999999999.99"), new BigDecimal("-9999999999999999999999999999999.99"), new BigDecimal("-99999999999999999999999999999999.99"), new BigDecimal("-999999999999999999999999999999999.99"), new BigDecimal("-9999999999999999999999999999999999.99"), new BigDecimal("-99999999999999999999999999999999999.99"), new BigDecimal("-999999999999999999999999999999999999.99"), new BigDecimal("-9999999999999999999999999999999999999.99")};
        parseFormats = new String[]{"HH:mm:ss", "yyyyMMdd", "yyyyMMddHHmmss", "yyyy-M-d", "yyyy-M-d H:m:s", "yyyy-M-d H:m:s.S", "yyyy-M-d'T'H:m:s", "yyyy-M-d'T'H:m:s.S", "yyyy-MM-d", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS"};
        long[] codes = new long[parseFormats.length];
        for (int i = 0; i < parseFormats.length; ++i) {
            codes[i] = FnvHash.fnv1a_64(parseFormats[i]);
        }
        Arrays.sort(codes);
        parseFormatCodes = codes;
    }
}

