/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.spring.stat;

import com.alibaba.druid.support.profile.Profiler;
import com.alibaba.druid.support.spring.stat.SpringMethodInfo;
import com.alibaba.druid.support.spring.stat.SpringMethodStatValue;
import com.alibaba.druid.util.JdbcSqlStatUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class SpringMethodStat {
    private static final ThreadLocal<SpringMethodStat> currentLocal = new ThreadLocal();
    private final SpringMethodInfo methodInfo;
    private final AtomicInteger runningCount = new AtomicInteger();
    private final AtomicInteger concurrentMax = new AtomicInteger();
    private final AtomicLong executeCount = new AtomicLong(0L);
    private final AtomicLong executeErrorCount = new AtomicLong(0L);
    private final AtomicLong executeTimeNano = new AtomicLong();
    private final AtomicLong jdbcFetchRowCount = new AtomicLong();
    private final AtomicLong jdbcUpdateCount = new AtomicLong();
    private final AtomicLong jdbcExecuteCount = new AtomicLong();
    private final AtomicLong jdbcExecuteErrorCount = new AtomicLong();
    private final AtomicLong jdbcExecuteTimeNano = new AtomicLong();
    private final AtomicLong jdbcCommitCount = new AtomicLong();
    private final AtomicLong jdbcRollbackCount = new AtomicLong();
    private final AtomicLong jdbcPoolConnectionOpenCount = new AtomicLong();
    private final AtomicLong jdbcPoolConnectionCloseCount = new AtomicLong();
    private final AtomicLong jdbcResultSetOpenCount = new AtomicLong();
    private final AtomicLong jdbcResultSetCloseCount = new AtomicLong();
    private volatile Throwable lastError;
    private volatile long lastErrorTimeMillis;
    private volatile long histogram_0_1;
    private volatile long histogram_1_10;
    private volatile long histogram_10_100;
    private volatile long histogram_100_1000;
    private volatile int histogram_1000_10000;
    private volatile int histogram_10000_100000;
    private volatile int histogram_100000_1000000;
    private volatile int histogram_1000000_more;
    static final AtomicLongFieldUpdater<SpringMethodStat> histogram_0_1_Updater = AtomicLongFieldUpdater.newUpdater(SpringMethodStat.class, "histogram_0_1");
    static final AtomicLongFieldUpdater<SpringMethodStat> histogram_1_10_Updater = AtomicLongFieldUpdater.newUpdater(SpringMethodStat.class, "histogram_1_10");
    static final AtomicLongFieldUpdater<SpringMethodStat> histogram_10_100_Updater = AtomicLongFieldUpdater.newUpdater(SpringMethodStat.class, "histogram_10_100");
    static final AtomicLongFieldUpdater<SpringMethodStat> histogram_100_1000_Updater = AtomicLongFieldUpdater.newUpdater(SpringMethodStat.class, "histogram_100_1000");
    static final AtomicIntegerFieldUpdater<SpringMethodStat> histogram_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(SpringMethodStat.class, "histogram_1000_10000");
    static final AtomicIntegerFieldUpdater<SpringMethodStat> histogram_10000_100000_Updater = AtomicIntegerFieldUpdater.newUpdater(SpringMethodStat.class, "histogram_10000_100000");
    static final AtomicIntegerFieldUpdater<SpringMethodStat> histogram_100000_1000000_Updater = AtomicIntegerFieldUpdater.newUpdater(SpringMethodStat.class, "histogram_100000_1000000");
    static final AtomicIntegerFieldUpdater<SpringMethodStat> histogram_1000000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(SpringMethodStat.class, "histogram_1000000_more");

    public SpringMethodStat(SpringMethodInfo methodInfo) {
        this.methodInfo = methodInfo;
    }

    public SpringMethodStatValue getStatValue(boolean reset) {
        SpringMethodStatValue val2 = new SpringMethodStatValue();
        val2.setClassName(this.getMethodInfo().getClassName());
        val2.setSignature(this.getMethodInfo().getSignature());
        val2.setRunningCount(this.getRunningCount());
        val2.setConcurrentMax(JdbcSqlStatUtils.get(this.concurrentMax, reset));
        val2.setExecuteCount(JdbcSqlStatUtils.get(this.executeCount, reset));
        val2.setExecuteErrorCount(JdbcSqlStatUtils.get(this.executeErrorCount, reset));
        val2.setExecuteTimeNano(JdbcSqlStatUtils.get(this.executeTimeNano, reset));
        val2.setJdbcFetchRowCount(JdbcSqlStatUtils.get(this.jdbcFetchRowCount, reset));
        val2.setJdbcUpdateCount(JdbcSqlStatUtils.get(this.jdbcUpdateCount, reset));
        val2.setJdbcExecuteCount(JdbcSqlStatUtils.get(this.jdbcExecuteCount, reset));
        val2.setJdbcExecuteErrorCount(JdbcSqlStatUtils.get(this.jdbcExecuteErrorCount, reset));
        val2.setJdbcExecuteTimeNano(JdbcSqlStatUtils.get(this.jdbcExecuteTimeNano, reset));
        val2.setJdbcCommitCount(JdbcSqlStatUtils.get(this.jdbcCommitCount, reset));
        val2.setJdbcRollbackCount(JdbcSqlStatUtils.get(this.jdbcRollbackCount, reset));
        val2.setJdbcPoolConnectionOpenCount(JdbcSqlStatUtils.get(this.jdbcPoolConnectionOpenCount, reset));
        val2.setJdbcPoolConnectionCloseCount(JdbcSqlStatUtils.get(this.jdbcPoolConnectionCloseCount, reset));
        val2.setJdbcResultSetOpenCount(JdbcSqlStatUtils.get(this.jdbcResultSetOpenCount, reset));
        val2.setJdbcResultSetCloseCount(JdbcSqlStatUtils.get(this.jdbcResultSetCloseCount, reset));
        val2.setLastError(this.lastError);
        val2.setLastErrorTimeMillis(this.lastErrorTimeMillis);
        if (reset) {
            this.lastError = null;
            this.lastErrorTimeMillis = 0L;
        }
        val2.histogram_0_1 = JdbcSqlStatUtils.get(this, histogram_0_1_Updater, reset);
        val2.histogram_1_10 = JdbcSqlStatUtils.get(this, histogram_1_10_Updater, reset);
        val2.histogram_10_100 = JdbcSqlStatUtils.get(this, histogram_10_100_Updater, reset);
        val2.histogram_100_1000 = JdbcSqlStatUtils.get(this, histogram_100_1000_Updater, reset);
        val2.histogram_1000_10000 = JdbcSqlStatUtils.get(this, histogram_1000_10000_Updater, reset);
        val2.histogram_10000_100000 = JdbcSqlStatUtils.get(this, histogram_10000_100000_Updater, reset);
        val2.histogram_100000_1000000 = JdbcSqlStatUtils.get(this, histogram_100000_1000000_Updater, reset);
        val2.histogram_1000000_more = JdbcSqlStatUtils.get(this, histogram_1000000_more_Updater, reset);
        return val2;
    }

    public void reset() {
        this.concurrentMax.set(0);
        this.executeCount.set(0L);
        this.executeErrorCount.set(0L);
        this.executeTimeNano.set(0L);
        this.jdbcFetchRowCount.set(0L);
        this.jdbcUpdateCount.set(0L);
        this.jdbcExecuteCount.set(0L);
        this.jdbcExecuteErrorCount.set(0L);
        this.jdbcExecuteTimeNano.set(0L);
        this.jdbcCommitCount.set(0L);
        this.jdbcRollbackCount.set(0L);
        this.jdbcPoolConnectionOpenCount.set(0L);
        this.jdbcPoolConnectionCloseCount.set(0L);
        this.jdbcResultSetOpenCount.set(0L);
        this.jdbcResultSetCloseCount.set(0L);
        this.lastError = null;
        this.lastErrorTimeMillis = 0L;
        histogram_0_1_Updater.set(this, 0L);
        histogram_1_10_Updater.set(this, 0L);
        histogram_10_100_Updater.set(this, 0L);
        histogram_100_1000_Updater.set(this, 0L);
        histogram_1000_10000_Updater.set(this, 0);
        histogram_10000_100000_Updater.set(this, 0);
        histogram_100000_1000000_Updater.set(this, 0);
        histogram_1000000_more_Updater.set(this, 0);
    }

    public SpringMethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public static SpringMethodStat current() {
        return currentLocal.get();
    }

    public static void setCurrent(SpringMethodStat current) {
        currentLocal.set(current);
    }

    public void beforeInvoke() {
        int max;
        currentLocal.set(this);
        int running = this.runningCount.incrementAndGet();
        while (running > (max = this.concurrentMax.get()) && !this.concurrentMax.compareAndSet(max, running)) {
        }
        this.executeCount.incrementAndGet();
        Profiler.enter(this.methodInfo.getSignature(), "SPRING");
    }

    public void afterInvoke(Throwable error, long nanos) {
        this.runningCount.decrementAndGet();
        this.executeTimeNano.addAndGet(nanos);
        this.histogramRecord(nanos);
        if (error != null) {
            this.executeErrorCount.incrementAndGet();
            this.lastError = error;
            this.lastErrorTimeMillis = System.currentTimeMillis();
        }
        Profiler.release(nanos);
    }

    private void histogramRecord(long nanos) {
        long millis = nanos / 1000L / 1000L;
        if (millis < 1L) {
            histogram_0_1_Updater.incrementAndGet(this);
        } else if (millis < 10L) {
            histogram_1_10_Updater.incrementAndGet(this);
        } else if (millis < 100L) {
            histogram_10_100_Updater.incrementAndGet(this);
        } else if (millis < 1000L) {
            histogram_100_1000_Updater.incrementAndGet(this);
        } else if (millis < 10000L) {
            histogram_1000_10000_Updater.incrementAndGet(this);
        } else if (millis < 100000L) {
            histogram_10000_100000_Updater.incrementAndGet(this);
        } else if (millis < 1000000L) {
            histogram_100000_1000000_Updater.incrementAndGet(this);
        } else {
            histogram_1000000_more_Updater.incrementAndGet(this);
        }
    }

    public long[] getHistogramValues() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public Date getLastErrorTime() {
        if (this.lastErrorTimeMillis <= 0L) {
            return null;
        }
        return new Date(this.lastErrorTimeMillis);
    }

    public long getLastErrorTimeMillis() {
        return this.lastErrorTimeMillis;
    }

    public int getRunningCount() {
        return this.runningCount.get();
    }

    public int getConcurrentMax() {
        return this.concurrentMax.get();
    }

    public long getExecuteCount() {
        return this.executeCount.get();
    }

    public long getExecuteErrorCount() {
        return this.executeErrorCount.get();
    }

    public long getExecuteTimeNano() {
        return this.executeTimeNano.get();
    }

    public long getExecuteTimeMillis() {
        return this.getExecuteTimeNano() / 1000000L;
    }

    public void addJdbcFetchRowCount(long delta) {
        this.jdbcFetchRowCount.addAndGet(delta);
    }

    public long getJdbcFetchRowCount() {
        return this.jdbcFetchRowCount.get();
    }

    public void addJdbcUpdateCount(long updateCount) {
        this.jdbcUpdateCount.addAndGet(updateCount);
    }

    public long getJdbcUpdateCount() {
        return this.jdbcUpdateCount.get();
    }

    public void incrementJdbcExecuteCount() {
        this.jdbcExecuteCount.incrementAndGet();
    }

    public void addJdbcExecuteCount(long executeCount) {
        this.jdbcExecuteCount.addAndGet(executeCount);
    }

    public long getJdbcExecuteCount() {
        return this.jdbcExecuteCount.get();
    }

    public long getJdbcExecuteErrorCount() {
        return this.jdbcExecuteErrorCount.get();
    }

    public void addJdbcExecuteErrorCount(long executeCount) {
        this.jdbcExecuteErrorCount.addAndGet(executeCount);
    }

    public void incrementJdbcExecuteErrorCount() {
        this.jdbcExecuteErrorCount.incrementAndGet();
    }

    public long getJdbcExecuteTimeMillis() {
        return this.getJdbcExecuteTimeNano() / 1000000L;
    }

    public long getJdbcExecuteTimeNano() {
        return this.jdbcExecuteTimeNano.get();
    }

    public void addJdbcExecuteTimeNano(long nano) {
        this.jdbcExecuteTimeNano.addAndGet(nano);
    }

    public void incrementJdbcCommitCount() {
        this.jdbcCommitCount.incrementAndGet();
    }

    public long getJdbcCommitCount() {
        return this.jdbcCommitCount.get();
    }

    public void addJdbcCommitCount(long commitCount) {
        this.jdbcCommitCount.addAndGet(commitCount);
    }

    public void incrementJdbcRollbackCount() {
        this.jdbcRollbackCount.incrementAndGet();
    }

    public long getJdbcRollbackCount() {
        return this.jdbcRollbackCount.get();
    }

    public void addJdbcRollbackCount(long rollbackCount) {
        this.jdbcRollbackCount.addAndGet(rollbackCount);
    }

    public long getJdbcPoolConnectionOpenCount() {
        return this.jdbcPoolConnectionOpenCount.get();
    }

    public void addJdbcPoolConnectionOpenCount(long delta) {
        this.jdbcPoolConnectionOpenCount.addAndGet(delta);
    }

    public void incrementJdbcPoolConnectionOpenCount() {
        this.jdbcPoolConnectionOpenCount.incrementAndGet();
    }

    public long getJdbcPoolConnectionCloseCount() {
        return this.jdbcPoolConnectionCloseCount.get();
    }

    public void addJdbcPoolConnectionCloseCount(long delta) {
        this.jdbcPoolConnectionCloseCount.addAndGet(delta);
    }

    public void incrementJdbcPoolConnectionCloseCount() {
        this.jdbcPoolConnectionCloseCount.incrementAndGet();
    }

    public long getJdbcResultSetOpenCount() {
        return this.jdbcResultSetOpenCount.get();
    }

    public void addJdbcResultSetOpenCount(long delta) {
        this.jdbcResultSetOpenCount.addAndGet(delta);
    }

    public void incrementJdbcResultSetOpenCount() {
        this.jdbcResultSetOpenCount.incrementAndGet();
    }

    public long getJdbcResultSetCloseCount() {
        return this.jdbcResultSetCloseCount.get();
    }

    public void addJdbcResultSetCloseCount(long delta) {
        this.jdbcResultSetCloseCount.addAndGet(delta);
    }

    public void incrementJdbcResultSetCloseCount() {
        this.jdbcResultSetCloseCount.incrementAndGet();
    }

    public Map<String, Object> getStatData() {
        return this.getStatValue(false).getData();
    }
}

