/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.profile;

import com.alibaba.druid.support.profile.ProfileEntryStatValue;
import com.alibaba.druid.util.JdbcSqlStatUtils;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ProfileEntryStat {
    private volatile long executeCount = 0L;
    private volatile long executeTimeNanos = 0L;
    private static final AtomicLongFieldUpdater<ProfileEntryStat> executeCountUpdater = AtomicLongFieldUpdater.newUpdater(ProfileEntryStat.class, "executeCount");
    private static final AtomicLongFieldUpdater<ProfileEntryStat> executeTimeNanosUpdater = AtomicLongFieldUpdater.newUpdater(ProfileEntryStat.class, "executeTimeNanos");

    public ProfileEntryStatValue getValue(boolean reset) {
        ProfileEntryStatValue val2 = new ProfileEntryStatValue();
        val2.setExecuteCount(JdbcSqlStatUtils.get(this, executeCountUpdater, reset));
        val2.setExecuteTimeNanos(JdbcSqlStatUtils.get(this, executeTimeNanosUpdater, reset));
        return val2;
    }

    public long getExecuteCount() {
        return this.executeCount;
    }

    public void addExecuteCount(long delta) {
        executeCountUpdater.addAndGet(this, delta);
    }

    public long getExecuteTimeNanos() {
        return this.executeTimeNanos;
    }

    public void addExecuteTimeNanos(long delta) {
        executeTimeNanosUpdater.addAndGet(this, delta);
    }
}

